---
title: Python Function Divmod
localeTitle: Функция Python Divmod
---
# Python `divmod(a,b)`

`divmod()` является встроенной функцией в Python 3, которая возвращает частное и остальное при делении числа `a` на число `b` . В качестве аргументов `a` & `b` требуется два числа. Аргумент не может быть сложным числом.

## аргументация

Он принимает два аргумента `a` & `b` - целое число или десятичное число. Он не может быть сложным числом.

## Возвращаемое значение

Возвращаемым значением будет пара положительных чисел, состоящая из частного и оставшегося числа, полученного делением `a` на `b` . В случае смешанных типов операндов будут применяться правила для двоичных арифметических операторов.  
Для **аргументов числа Integer** возвращаемое значение будет таким же, как `(a // b, a % b)` .  
Для **аргументов десятичного числа** возвращаемое значение будет таким же, как `(q, a % b)` , где `q` обычно является **math.floor (a / b),** но может быть на 1 меньше.

## Образец кода
```
print(divmod(5,2)) # prints (2,1) 
 print(divmod(13.5,2.5)) # prints (5.0, 1.0) 
 q,r = divmod(13.5,2.5)  # Assigns q=quotient & r= remainder 
 print(q) # prints 5.0 because math.floor(13.5/2.5) = 5.0 
 print(r) # prints 1.0 because (13.5 % 2.5) = 1.0 
```

![:rocket:](https://forum.freecodecamp.com/images/emoji/emoji_one/rocket.png?v=3 ": Ракета:") [REPL Это!](https://repl.it/FGLK/0)

[Официальные документы](https://docs.python.org/3/library/functions.html#divmod)