---
title: React with Webpack File Structure
localeTitle: Реагирование с файловой структурой Webpack
---
Теперь пришло время настроить нашу файловую структуру, прежде чем писать какой-либо код.

Во-первых, давайте создадим новый файл с именем `.gitignore` :
```
touch .gitignore 
```

Этот файл будет содержать список всех файлов и папок, которые **не** будут включены, когда мы продвинем наш проект в GitHub. Существует веб-сайт, который предлагает шаблонный код для файлов `.gitignore` , что очень полезно, потому что часто файл `.gitignore` может быть довольно длинным и подробным, и мы можем забыть некоторые файлы или папки, которые мы хотим, чтобы Git игнорировал.

Перейдите в [https://www.gitignore.io/](https://www.gitignore.io/) и введите `Node` в строку поиска, затем нажмите « `Generate` . Это создаст файл, который выглядит так:
```
# Created by https://www.gitignore.io/api/node 
 
 ### Node ### 
 # Logs 
 logs 
 *.log 
 npm-debug.log* 
 
 # Runtime data 
 pids 
 *.pid 
 *.seed 
 
 # Directory for instrumented libs generated by jscoverage/JSCover 
 lib-cov 
 
 # Coverage directory used by tools like istanbul 
 coverage 
 
 # Grunt intermediate storage (http://gruntjs.com/creating-plugins#storing-task-files) 
 .grunt 
 
 # node-waf configuration 
 .lock-wscript 
 
 # Compiled binary addons (http://nodejs.org/api/addons.html) 
 build/Release 
 
 # Dependency directories 
 node_modules 
 jspm_packages 
 
 # Optional npm cache directory 
 .npm 
 
 # Optional REPL history 
 .node_repl_history 
```

Теперь мы можем скопировать и вставить это в наш `.gitignore` файл.

Обратите внимание, что файл `.gitignore` должен всегда включать `node_modules` . Это чрезвычайно важно, потому что мы не хотим включать нашу папку `node_modules` с нашими Git- `node_modules` , поскольку они занимают много места на диске и могут быть установлены с `npm install` , что относится к нашему `package.json` .

Большинство файлов и папок, перечисленных в нашем файле `.gitignore` еще не существует в нашем проекте, но если они это сделают в будущем, они не будут включены в наши Git-коммиты, что важно и полезно, потому что мы должны быть избирательно о том, что мы совершаем.

Теперь нам нужно создать новую папку, которая будет содержать содержимое нашего кода **разработки** . Назовем это `src` :
```
mkdir src 
```

Затем нам нужно создать папку, которая будет содержать файлы, которые мы используем для **производственных** целей. Мы будем называть эту папку `dist` :
```
mkdir dist 
```

*   [Справка: Подробнее о папках `src` и `dist`](http://stackoverflow.com/questions/23730882/what-is-the-role-of-src-and-dist-folders/23731040#23731040)

Теперь, когда мы установили наши пакеты и создали пустые папки `src` и `dist` , наше дерево будет выглядеть так (не включая `.gitignore` , который является скрытым файлом):
```
. 
 ├── dist 
 ├── node_modules 
 ├── package.json 
 ├── src 
 └── webpack.config.js 
```

Теперь мы можем создать новую папку `js` которая входит в нашу папку `src` . Это будет содержать весь наш код React:
```
mkdir src/js 
```

Мы можем пойти и создать пустой `client.js` в нашем `src/js` . Это будет наш основной файл React:
```
touch src/js/client.js 
```

Нам также необходима `index.html` , который **не должен** идти в нашу `src` папку, а в нашу `dist` папку, так как он необходим для **производства** нашего приложения:
```
touch dist/index.html 
```

Итак, наше дерево выглядит примерно так:
```
. 
 ├── dist 
 │   └── index.html 
 ├── node_modules 
 ├── package.json 
 ├── src 
 │   └── js 
 │       └── client.js 
 └── webpack.config.js 

```