---
title: Sass Syntax and Tools
localeTitle: Синтаксис Sass и инструменты
---
_«Художник так же хорош, как и его инструменты»._

Это не всегда так, но инструменты, которые мы используем, могут сделать нашу жизнь проще и наши задачи более управляемы. Представьте, что вы пишете код без сочетаний клавиш или доступных фрагментов! Не конец света, но вы получаете суть.

«Инструменты», или чаще называемые директивами, мы будем обсуждать на самом деле встроенные функции, поставляемые в комплекте с Sass, и могут помочь нам как разработчикам написать DRY-er (Do not Repeat Yourself) и более чистый код.

_Если вы хотите следовать в своем текстовом редакторе, я рекомендую установить **синтаксис синтаксиса Sass** . Atom и Sublime Text, а также несколько других редакторов поддерживают их._

## переменные

Если вы написали код на другом языке программирования (JavaScript, Python, Java, C и т. Д.), То вы знакомы с концепцией переменных. Если нет, то переменные в основном объявляются объявлением, которые могут хранить какое-то значение, например, число или строку.

В Sass переменные работают по существу одинаково и могут быть объявлены символом «$» рядом с именем переменной:
```
$main-color: #CCCCCC; 
```

Переменная выше хранит шестнадцатеричный код цвета для оттенка серого. Мы можем объявить эту переменную в любом `.scss` или `.sass` котором мы работаем. Мы также можем включить эту переменную в тег (тег HTML5, ID, класс, псевдоселекторы) при стилизации:
```
$main-color: #CCCCCC; 
 
 header { 
  background-color: $main-color; 
 } 
```

В этом фрагменте кода мы присвоили значение `background-color` заголовка значению, хранящемуся в `$main-color` , которое (когда Sass компилируется в CSS) выводится как:
```
header { 
  background-color: #CCCCCC; 
 } 
```

Ухоженная! Но разве мы не могли бы установить `background-color` в `#CCCCCC` в первую очередь? Ответ - да, но есть нечто большее, чем это.

Предположим, мы создаем многостраничный веб-сайт для клиента, и мы просто закончили выбор простой трехцветной «цветовой схемы». Наша панель навигации, нижний колонтитул одного цвета, и, возможно, наши элементы статьи, абзацы и заголовки являются одним из двух оставшихся цветов. Затем в один прекрасный день клиент меняет свое мнение на выбранную нами цветовую схему и хочет, чтобы она изменилась. Отлично.

Итак, нам поручено пройти через несколько таблиц стилей (или, может быть, одну массивную таблицу стилей, если вы этого пожелаете) и изменить все эти значения цвета. Может быть, мы смешаем его. Или, может быть, мы пропустили один, и нам нужно продолжать исправлять их.

С переменными (и использованием парциальных элементов Sass, которые мы обсудим позже) мы можем скорректировать значения в объявлениях переменных, и везде, где мы использовали переменные в нашей таблице стилей (s), значения будут меняться, чтобы отразить изменение переменной, которое мы изменили. Это единственный пример того, насколько удобными могут быть переменные в Sass. Переменные становятся более важными, поскольку мы добавляем к нашей инструментальной панели Sass.

На этой заметке давайте займемся миксинами.

## Примеси

Mixin - это блок повторно используемого кода, который может принимать аргументы, подобно функции в JavaScript. Однако это не следует путать с фактической `@function` в Sass.

Миксины объявляются путем префикса символа «@» перед словом «mixin», а затем имя mixin. Ниже приведен пример mixin btn, который принимает два аргумента и применяет их к свойствам CSS:
```
@mixin btn($color, $text-color) { 
  background-color: $color; 
  color: $text-color; 
  padding: 1em; 
 } 
```

После создания mixin ничего не произойдет по умолчанию, потому что мы не использовали mixin (аналогично написанию функции или вызову функции). Давайте интегрируем наш mixin. Мы включим его в селектор `button` HTML5 `button` используя оператор `@include` :

_`@include` позволяет нам внедрить наш стиль mixin в селектор CSS по нашему выбору. В этом случае в качестве аргументов передается селектор `button` со значениями синий и белый._
```
button { 
  @include btn(blue, white); 
 } 
```

Это то, что мы можем использовать в любом другом селекторе HTML, если мы этого хотим. Это будет скомпилировано до:
```
button { 
  background-color: blue; 
  color: white; 
  padding: 1em; 
 } 
```

Просто используя единственную строку `@include btn(blue, white);` внутри нашего селектора кнопок мы можем ввести весь код, выписанный внутри нашего mixin с синим и белым, в качестве аргументов. Кроме того, мы можем установить значения по умолчанию для аргументов, переданных в mixin. Например, предположим, что мы хотим, чтобы наша кнопка mixin по умолчанию имела определенный цвет и цвет шрифта, если при вызове не было передано значений:
```
@mixin button($color: green, $text-color: red) { 
  background-color: $color; 
  color: $text-color; 
  padding: 1em; 
 } 
```

Набрав значение «:», за которым следует значение по умолчанию, которое мы хотим установить, мы присвоили значение green в качестве значения по умолчанию для нашего аргумента `$color` , а красный - как значение по умолчанию для нашего аргумента `$text-color` .

Теперь, если бы мы назвали наш mixin без каких-либо значений ...
```
button { 
  @include btn; 
 } 
```

Это сводится к:
```
button { 
  background-color: green; 
  color: red; 
  padding: 1em; 
 } 
```

Если бы мы захотели использовать наши переменные для использования с нашим микшином, мы могли бы это сделать:
```
$main-color: #CCCCCC; 
 $second-color: #FFFFFF; 
 
 @mixin button($color: $main-color, $text-color: $second-color) { 
  background-color: $color; 
  color: $text-color; 
  padding: 1em; 
 } 
```

В приведенном выше примере мы объявляем две переменные с различными шестнадцатеричными значениями цвета, а затем устанавливаем аргументы `$color` и `$text-color` по умолчанию для наших переменных, если аргумент не передается.

Часто считается хорошей практикой устанавливать значения по умолчанию для mixin, но определенно не нужно. Вы обнаружите, что многие разработчики имеют собственный способ написания кода и различные мнения о том, что считается «лучшим».

Веселье здесь не остановится. Есть много полезных полезных трюков, которые мы можем выполнить при написании миксинов и бесконечных возможностей в том, как их писать. Важно убрать из mixins то, что они служат модулями или «объектами», в которых мы можем объявлять определенные стили, передавать значения и повторно использовать в нашем коде, где нужно, а не постоянно повторять себя при стилизации разных элементов. Они могут помочь нам оставаться верными принципу DRY.

## Расширяет

Последний инструмент, который мы обсудим, - это директива расширения. Расширения могут использоваться для дублирования стиля, который мы применяли ранее к другому элементу. Тем не менее, гораздо больше происходит за кулисами при реализации расширения, и это может привести к некоторым непредвиденным побочным эффектам для нашего стиля, если мы не будем осторожны.

Ниже приведен пример использования директивы расширения:
```
.primary-module { 
  color: red; 
 } 
 
 .another-module { 
  @extend .primary-module; 
 } 
 
 // This ouputs the following CSS 
 
 .primary-module, .another-module { 
  color: red; 
 } 
```

Ничего слишком теневого здесь. У нас есть селекторный таргетинг. `.another-module` который использует расширение для клонирования, которое было применено к селектору `.primary-module` . Это приводит к стилизации `color: red;` применяется к классу `.primary-module` и `.another-module` . Логично до сих пор и инструмент, который имеет аналогичный эффект, включая микширование на нескольких элементах, которые должны использовать один и тот же стиль.

Теперь давайте более подробно рассмотрим другой пример и выберем, где ограничение директивы немного усложняет:
```
.primary-module p { 
  color: red; 
 } 
 
 .another-module { 
  @extend .primary-module; 
 } 
 
 // This outputs the following CSS 
 
 .primary-module p, .another-module p { 
  color: red; 
 } 
```

Ты поймал это? Селектор `.another-module` использует расширение на `.primary-module p` . Обратите внимание, что поскольку `.primary-module` имеет селектор спуска `p` (тег абзаца), когда вызывается расширение и скомпилирован наш код Sass, стиль `color: red;` применяется к `.primary-module p` и `.another-module p` .

Что происходит, так это то, что директива extend не только клонирует стиль из `.primary-module p` , но и клонирует тег селектора спуска `p` и добавляет его в `.another-module` . Мы копируем стиль и селектор потомков того, что мы заимствовали. В результате стиль, который мы расширили, применяется к элементам абзаца, которые являются потомками `.another-module` а не просто элементами с классом `.another-module` .

Вы можете видеть, где что-то вроде этого может получиться волосатым, если мы не знаем, что делает.

Итак, мы заглянули за шторы на продолжениях, и теперь вы можете подумать. В _чем смысл использования расширений? Стоит ли это или я могу просто использовать микшины?_

Короткий ответ (есть еще много, что можно сказать по этой теме) заключается в том, что часто расширения будут использоваться для целенаправленного использования наследования стилей, применяемых к другим элементам, или для особого использования так называемых « **молчащих» классов** в Sass. Расширения могут, как правило, выполнять то, что могут использоваться миксинами при их использовании, но не следует бездумно использовать вместо другого. Практика расширяет и использует их с определенной целью.

Что касается тихих занятий, это то, что, надеюсь, будет освещено в следующем разделе этой статьи. Пока что просто знайте, что тихие классы являются селекторами в Sass, которые имеют префикс с символом «%» и не будут скомпилированы вообще, если не вызваны расширением.

## Вывод

Если вы дошли до конца этой статьи, вы заслуживаете признания. Я написал это в надежде объяснить Сасса таким образом, который, как мне бы хотелось, мне научили, когда я впервые начал с ним общаться. Если CSS - это то, с чем вы боретесь или всегда испытывали опасение из-за того, насколько быстро это становится беспорядком, то, надеюсь, Сасс начнет смягчать некоторые из этих разочарований.

Эта статья предназначена как «крутой курс», чтобы ваши ноги были мокрыми в мире Сасса. По-прежнему существует значительное количество инструментов и функций, которые делают Sass shine, а также лучшие практики, когда дело доходит до **структурирования ваших таблиц стилей и разбивки их на частичные** .

Мой совет - начать песочницу в своем собственном текстовом редакторе и в [Sassmeister,](http://www.sassmeister.com/) чтобы получить более удобную концепцию, [описанную](http://www.sassmeister.com/) в этой статье. Также будьте в курсе курса Free Code Camp Sass в ближайшее время.

Выйдите туда и сравните свою игру Sass.