---
title: Storing Mongo Username  Password Persistently Using Dotenv
localeTitle: Сохранение Mongo Логин Пароль Устойчиво Использование Dotenv
---
## Хранение Защищенной информации для приложений с dotenv

В этой статье мы расскажем о том, как сохранить учетную информацию пользователя и пароля для безопасного доступа к базе данных на сторонних сайтах, таких как mLab, в локальной тестовой среде, чтобы защитить их от всех, кто смотрит на ваш публичный репозиторий на сайте github.

Безопасная или личная информация никогда не должна храниться внутри вашего кода и помещаться в репозиторий, поскольку она будет публично раскрыта, что подвергает вашу информацию риску и ставит вас под угрозу потерять доступ к API или базе данных, если кто-то использует ваши учетные данные обманным путем.

[В этой статье вики](//forum.freecodecamp.com/t/guide-for-using-mongodb-and-deploying-to-heroku/19347/3) обсуждается, как защитить ваши учетные данные с помощью команды export, но для того, чтобы эти переменные были постоянными, у вас есть два варианта. Однако переменные enivorment, установленные таким образом, стираются каждый раз, когда перезагружается оболочка, например, когда вы завершаете работу своего компьютера и перезапускаете новый сеанс кодирования.

Вам нужно будет пройти все шаги еще раз, чтобы задать переменные среды каждый раз, когда вы запустили новую оболочку терминала. Это означает, что вам нужно будет хранить ваши учетные данные в текстовом файле где-нибудь или продолжать искать их в своей третьей учетной записи (например, mLab).

Выполнение этого каждый раз, когда вы начинаете новый сеанс, становится утомительным, и вместо того, чтобы хранить его в самом коде, где его легко найти, я покажу вам способ использования текстового файла и импорта ваших учетных данных.

Первый вариант - использовать ваш профиль оболочки и экспортировать эти переменные каждый раз, когда вы запускаете новый терминал. Однако за несколько недель разработки новых приложений и проектов ваш профиль оболочки будет забит массивным списком переменных, которые вам не понадобятся для каждого сеанса. Вам нужны только учетные данные для приложения, в котором вы сейчас работаете.

## Очистка репозитория git, содержащего безопасные учетные данные

Если вы уже подтолкнули ваш репозиторий к github с вашими учетными данными, хранящимися в базе данных, просто удаление их и повторное нажатие не поможет, потому что ваши учетные данные хранятся в вашей истории, что также видно для публики. Если это так, используйте эти команды для сброса вашего репозитория git, чтобы стереть вашу историю.

**Во-первых,** удалите свое репо из github. Когда мы будем готовы, вы создадите новый.

**Во-вторых,** удалите локальный репозиторий git из своего рабочего каталога.  
\-Изменить каталоги в свой рабочий каталог. Здесь должен быть ваш репозиторий .git.  
ОСТОРОЖНО: с помощью флага -rf можно удалить весь жесткий диск, если он не используется правильно. Я использую флаг -i, который означает интерактивность, чтобы быть уверенным, что я Вхожу в правильный каталог. После сортировки нескольких файлов, и я на 100% уверен, что я нахожусь в нужном месте, я убью эту команду и запустил ее снова без флага -i. Сделайте то, что вам больше всего нравится, но вам предложат полную резервную копию вашего компьютера (в нескольких местах) перед запуском команды -rm.
```
cd <project-name> 
 rm -i -rf .git 
```

**В-третьих** , обязательно обновите файл .gitignore, чтобы включить файл .env в дополнение к любым другим папкам, которые вы хотите сохранить конфиденциальными. Например, в этом файле могут быть локальные файлы IDE, такие как .idea / if using jetbrains. Мой файл .gitignore выглядит следующим образом. Обратите внимание, что вы можете добавить папку или файл здесь, прежде чем она будет создана без каких-либо ошибок.

`.gitignore`  
node\_modules  
.env  
данные/  
.idea /

**Наконец,** создайте новый репозиторий. Теперь вы готовы продолжить создание своего .env-файла и безопасно перенаправить свое репо на github и сохранить свои учетные данные в безопасности.

`git init`

## Как использовать dotenv в локальном приложении

Это может помочь узловой модуль dotenv. Чтобы использовать dotenv, вам необходимо потребовать его в коде приложения, вызвать на нем функцию config (), которая вытаскивает ваши учетные данные из локально сохраненного файла на вашем компьютере. Этот файл называется `.env`

**Шаг 1.** Создайте файл .env и сохраните в нем переменные.  
`MONGOLAB_URI="mongodb://username:password@ds01316.mlab.com:1316/food"`

**Шаг 2:** Требование dotenv в вашем основном приложении  
в вашем основном `app.js` (или как вы его назвали)  
`var dotenv = require('dotenv');`

**Шаг 3:** Вызовите функцию config на вашей переменной. (обратите внимание, что все это можно сделать в одной строке путем цепочки, но мне нравится видеть, что это происходит как отдельное действие).  
`dotenv.config();`

**Шаг 4.** Установите URL-адрес mongodb, вызвав переменные процесса:  
`var url = process.env.MONGOLAB_URI;`

Это решение защищает ваш код от безопасных учетных данных, которые вы не хотите использовать для публичного репозитория, при этом каждое приложение аккуратно организовано и экономит время при разработке.

**Рекомендации:**

[osxdaily.com](http://osxdaily.com/2015/07/28/set-enviornment-variables-mac-os-x/)

! \[\] (Http://cdn.osxdaily.com/wp-content/uploads/2014/08/terminal-icon-osx.png) ### [Где устанавливать переменные среды в Mac OS X](http://osxdaily.com/2015/07/28/set-enviornment-variables-mac-os-x/) В командной строке переменные среды определены для текущей оболочки и становятся унаследованными любой выполняемой командой или процессом. Они могут определять что-либо из оболочки по умолчанию, PATH, ...

[stackoverflow.com](http://stackoverflow.com/questions/35356692/best-practice-when-using-an-api-key-in-node-js)

[! \[Drake Main](https://i.stack.imgur.com/jRaTj.jpg?s=128&g=1) \] (http://stackoverflow.com/users/4956243/drake-main) #### [Лучшая практика при использовании ключа API в Node.js](http://stackoverflow.com/questions/35356692/best-practice-when-using-an-api-key-in-node-js)

\*\* node.js, api-key \*\*

спросил [Дрейк Майн](http://stackoverflow.com/users/4956243/drake-main) в [07:05 - 12 февраля 16](http://stackoverflow.com/questions/35356692/best-practice-when-using-an-api-key-in-node-js)

[stackoverflow.com](http://stackoverflow.com/questions/1213430/how-to-fully-delete-a-git-repository-created-with-init)

[! \[Peiniau](https://www.gravatar.com/avatar/9db1745a666cface1731c12d54e189e6?s=128&d=identicon&r=PG) \] (http://stackoverflow.com/users/105813/peiniau) #### [Как полностью удалить репозиторий git, созданный с помощью init?](http://stackoverflow.com/questions/1213430/how-to-fully-delete-a-git-repository-created-with-init)

\*\* git, git-init \*\*

спросил [Пейняу в 16:06](http://stackoverflow.com/users/105813/peiniau) [\- 31 июля 09](http://stackoverflow.com/questions/1213430/how-to-fully-delete-a-git-repository-created-with-init)