---
title: The History of Ruby
localeTitle: История Руби
---
[Ruby](https://www.ruby-lang.org/en/) - динамический, объектно-ориентированный, [рефлексивный](https://en.wikipedia.org/wiki/Reflection_(computer_programming) ) язык программирования с упором на простоту и производительность. Он имеет элегантный синтаксис, который естественно читать и легко писать. Он также имеет систему динамического типа и автоматическое управление памятью.

Известный своим [синтаксическим сахаром](https://en.wikipedia.org/wiki/Syntactic_sugar) , Ruby создан для счастья разработчика. Он был создан японским инженером-программистом [Юкихиро Мацумото](https://en.wikipedia.org/wiki/Yukihiro_Matsumoto) (также известным как Мац) как простой язык сценариев общего назначения для повседневной работы. Объединение элементов Perl, Smalltalk и Scheme в простой, но мощный синтаксис.

Ruby был задуман 24 февраля 1993 года. В 1999 году в списке рассылки рубиновой речи Юкихиро Мацумото описывает некоторые из его ранних идей о языке:

> Я говорил с моим коллегой о возможности объектно-ориентированного языка сценариев. Я знал Perl (Perl4, а не Perl5), но мне это не нравилось, потому что у него был запах игрушечного языка (он все еще есть). Объектно-ориентированный язык казался очень многообещающим. Тогда я знал Питона. Но мне это не понравилось, потому что я не думал, что это настоящий объектно-ориентированный язык. Возможности OO оказались дополнением к языку. Являясь языковым маньяком и фанатом OO в течение 15 лет, я действительно хотел получить подлинный объектно-ориентированный, простой в использовании язык сценариев. Я искал, но не мог найти его. Поэтому я решил это сделать.

Как и Perl, Ruby хорошо разбирается в обработке текста. Как и Smalltalk, все в Ruby является объектом, а Ruby имеет блоки, итераторы, мета-классы и другие хорошие вещи. Вы можете использовать Ruby для записи серверов, экспериментировать с прототипами и для повседневных задач программирования. В качестве полностью интегрированного объектно-ориентированного языка Ruby хорошо масштабируется.

К 2000 году Ruby был более популярен, чем Python в Японии; но так как была создана и выпущена веб- [фрейм Ruby on Rails](http://rubyonrails.org/) ; она росла не по дням, а по часам, за пределами Японии.

Сегодня Ruby on Rails считается сплошной веб-картой; и он стал пионером множества отличных практик в веб-разработке.

Аналогично, многие [популярные сайты](https://prograils.com/posts/top-10-famous-sites-built-with-ruby-on-rails) закодированы в Ruby on Rails, таких как GitHub, Airbnb, Groupon и т. Д.

Существуют различные [реализации](https://github.com/cogitator/ruby-implementations/wiki/List-of-Ruby-implementations) Ruby. JRuby (Ruby on JVM), Ruby MRI (также называемый CRuby) и IronRuby (Ruby для .NET и Silverlight) - одни из самых популярных.
