---
title: Understand How to Use Git Merge
localeTitle: Понять, как использовать Git Merge
---
Скажем, вы работаете над приложением, похожим на Reddit, но специально для фрагментов кода. В таком приложении вы, вероятно, будете иметь `master` ветвь, которая содержит все выпущенные функции, ветвь `dev` которая может содержать функции, которые были закодированы, но еще не реализованы. Каждый разработчик в команде будет создавать свои собственные ветви у ветви `dev` для отдельных функций. Структура репозитория будет выглядеть примерно так:
```
                                  --- Commit 3 --------- dev branch 
                                / 
 --- Commit 1 ---- Commit 2 ---------------------------- master branch 
```

Если вы решили объединить 3-й фиксатор ( `Commit 3` ) в `master` ветвь из ветви `dev` , то это будет так же просто, как запустить команду `git merge` потому что ветвь `dev` _обновлена_ с `master` ветвью: все коммиты в `master` ветви существуют в ветви `dev` . Вы можете объединить ветки, выполнив следующие команды:
```
git checkout dev 
 git merge master 
```

Результат будет примерно таким:
```
                                               --------- dev branch 
                                             / 
 --- Commit 1 ---- Commit 2 ---- Commit 3 -------------- master branch 
```

Теперь вы решили работать с функцией проверки подлинности. Чтобы работать с функцией аутентификации, вы создаете другую ветвь на основе ветви `dev` и решаете называть ее `auth` . Вот как выглядит структура репо:
```
                                                  ------ auth branch 
                                                / 
                                               --------- dev branch 
                                             / 
 --- Commit 1 ---- Commit 2 ---- Commit 3 -------------- master branch 
```

Если бы вы вносили какие-либо изменения в ветвь `auth` , объединение их с веткой `dev` было бы тривиально, потому что оно `dev` веткой `dev` . Теперь, когда вы работали над функцией аутентификации, один из разработчиков завершил кодирование функции подсветки синтаксиса и решил объединить ее с ветвью `dev` . Теперь репо выглядит следующим образом:
```
                                                  --- Commit 5 --- auth branch 
                                                / 
                                               --- Commit 4 ------ dev branch 
                                             / 
 --- Commit 1 ---- Commit 2 ---- Commit 3 ------------------------ master branch 
```

Ваша ветка, в терминологии Git, теперь является фиксацией за ветвью `dev` . Это означает, что вы не можете просто объединить две ветви: вы должны `auth` ветвь `auth` веткой `dev` . Это можно сделать с помощью `git merge` !

Объединение ветви `auth` веткой `dev` или веткой `dev` с `master` ветвью является простой и делает то, что вы ожидаете, но слияние в другую сторону имеет свои особенности, которые на первый взгляд не интуитивно понятны. Я могу болтать об этом, или я могу показать вам еще одну отличную диаграмму о том, что произойдет, если в этот момент вы объедините ветвь `dev` ветвью `auth` :
```
                                                  --- Commit 5 ----------- auth branch 
                                                /               / 
                                               --- Commit 4 -------------- dev branch 
                                             / 
 --- Commit 1 ---- Commit 2 ---- Commit 3 -------------------------------- master branch 
```

Посмотрите, что я там сделал? Посмотрите на диаграмму на секунду и попытайтесь понять, что происходит здесь, прежде чем двигаться дальше. Вы по существу сделали еще одну фиксацию для ветви `auth` с фиксациями в ветви `dev` . Но все в порядке, не так ли? В конце концов, в конце концов , я хотел , чтобы принести мою `auth` филиала уточненного с `dev` отраслью, и теперь уточненным? Ага. Но позвольте мне показать вам диаграмму, чтобы явно проиллюстрировать, что подразумевает другая диаграмма. Теперь ваша ветка `auth` выглядит так:
```
    --- Commit 5 ------- Commit 4 ------- auth branch 
  /                / 
 ------ Commit 4 --- --------------------- dev branch 
```

Увидеть это сейчас? Вы _скопировали_ фиксацию. Если бы вы теперь слились с веткой `dev` , это выглядело бы примерно так:
```
    --- Commit 5 ------- Commit 4 -------------------------------------- auth branch 
  /                /                  \ 
 ------- Commit 4 ----------------------- Commit 5 ---- Commit 4 -------- dev branch 
```

Вы дважды объединили одну и ту же фиксацию! Это, конечно же, не будет иметь никаких последствий для самого кода, но если вы в один прекрасный день решаете посмотреть на свои `git logs` , вы сразу поймете, насколько грязна ваша история Git, с некоторыми коммитами, которые делаются снова и снова. Если вы хотите вернуться к фиксации, было бы очень сложно решить, к какой фиксации нужно вернуться.

Вы предпочитаете использовать [Git-Rebase](http://forum.freecodecamp.com/t/how-to-use-git-rebase/13226) .