---
title: Us State Map Visualization Using D3js
localeTitle: Визуализация карты состояний с использованием D3js
---
![скриншот 2016-05-19 в 6 29 43](//discourse-user-assets.s3.amazonaws.com/original/2X/a/a4a31935c10185c660c713ba7651a30e0a11f1e8.png)

## Объяснение проекта:

**У нас есть образцы данных штатов США:** количество серьезных аварий, зарегистрированных для каждого штата в США.

_У нас есть эти данные по трем категориям:_ самый низкий показатель за месяц, средний показатель несчастных случаев в год и наибольшее количество сообщений в месяц, как показано в нижеприведенных образцах.

Мы хотим нарисовать карту США и визуализировать эти данные таким образом, чтобы при наведении мыши над состоянием она должна показывать эти данные для этого конкретного состояния.

## Пример данных:

`AZ: 13 41 57`

`CA: 41 60 81`

`NY: 6 35 54` и так далее.

## Советы и ресурсы:

### Пошаговые инструкции:

*   Во-первых, нам нужно будет создать карту США.
    
    1.  Вы можете создать карту с нуля, используя такие источники, как: [Stately.](https://intridea.github.io/stately/)
        
    2.  Получите уже созданную карту из [freehtml5maps](http://freehtml5maps.com) или используйте этот [Javascript](http://bl.ocks.org/NPashaP/raw/a74faf20b492ad377312/3513ad985b2fa93ea35f2fc864cb30540c298171/uStates.js)
        
*   Добавьте свою карту в основной javascript, используемый для визуализации
    

Например, `(script src="uStates.js")(/script) (!-- creates uStates. --)`

*   Создайте тег Div для хранения всплывающей подсказки и создайте SVG, чтобы удерживать карту.

Например,

`javascript (div id="tooltip")(/div) (svg width="960" height="600" id="statesvg")(/svg)`

*   Создайте функцию подсказки для создания строки содержимого html в div tooltip.

Эта функция всплывающей подсказки вернет таблицу, и эта таблица будет отображаться всякий раз, когда мы наводим указатель мыши на состояние. Таблица должна быть чем-то вроде этого (как показано на первом рисунке): Аризона Низкий 13 Средний 41 Высокий 57

*   Нарисуйте состояния на id (#statesvg в нашем примере) с помощью функции data и tooltip.

Например, `uStates.draw("#statesvg", sampleData, tooltipFunc);`

**Конечный результат будет примерно таким: (Наведите указатель мыши на Калифорнию)**

![скриншот 2016-05-19 в 6 37 57](//discourse-user-assets.s3.amazonaws.com/original/2X/2/2c17548386b8591d84ac8f2541fecd8d68e7365c.png)

## Рекомендации:

1.  Примеры и документы [**D3.js.**](https://d3js.org)
2.  [**NPashaP GitHub**](https://github.com/NPashaP)
3.  [**величавый**](https://intridea.github.io/stately/)
4.  [**FreeHTML5Maps**](http://freehtml5maps.com)