---
title: Use GitHub Static Pages to Host Your Front End Projects
localeTitle: Используйте статические страницы GitHub для размещения ваших проектов переднего плана
---
**Выгоды**

Я обожаю Codepen.io, это замечательный, простой в использовании инструмент для простого внешнего тестирования. Но по мере того, как проекты ГЦК стали более сложными, я понял, что кодирование на местном уровне собиралось спасти мне кучу головных болей. Мой текстовый редактор и [коммандит кода](https://incident57.com/codekit/) просто ускользнут.

*   Автозаполнение
*   Скомпилируйте все (codepen действительно перетаскивал попытку скомпилировать Jade)
*   Лучшее автоматическое обновление
*   Встроенная беседка
*   Управление версиями Git
*   Улучшенный экранный опыт в сфере недвижимости

## Git to GitHub

Поскольку я уже сохраняю локально и использую git для управления версиями, я решил, что могу загрузить его в GitHub. Кроме того, GitHub обладает фантастическим, бесплатным сервисом для интерфейсных проектов под названием [GitHub Pages](https://pages.github.com/) . Просто обновите свое репо и ваши изменения вживую.

Как это работает, просто. GitHub проверяет, имеет ли ваш репозиторий ветвь с именем `gh-pages` и обслуживает любой код, который находится в этой ветке. Здесь нет back-end, но HTML, CSS и JS работают как шарм.

## Первые вещи сначала

Давайте создадим новую папку для вашего проекта. В качестве примера я буду использовать проект [Camper News](http://www.freecodecamp.com/challenges/stylize-stories-on-camper-news) .

Попал в ваш рабочий каталог и создал новый. Вы можете сделать это в терминале (или нет).

![Каталог проектов](//discourse-user-assets.s3.amazonaws.com/original/2X/2/2e3faaa2752657c592a9991ceed29a0200f332e6.png)

Теперь зайдите в каталог проекта и (наверняка в терминале на этот раз) используйте команду `git init` . Обратите внимание: в этом руководстве предполагается, [что у вас установлен git](https://git-scm.com/book/en/v2/Getting-Started-Installing-Git) .

Хорошо, потрясающе. Теперь мы готовы работать.

## Следующие шаги

Создайте несколько файлов в каталоге campNews. Я не знаю, возможно, index.html и, возможно, app.css и app.js, или любое другое соглашение об именах, которое вы предпочитаете. Поместите свой код в эти файлы. Хорошо, теперь мы готовы к нашей первой фиксации. Требуется **два шага** .

1.  `git add -A` подготовит все эти новые файлы и новый код внутри них
2.  `git commit -m 'relevant message'` выполнит всю работу, которую вы сделали, с веткой, в которой вы сейчас находитесь (по умолчанию «мастер»)

## Ключ от всего этого

Хорошо, пока мы все еще местные. Есть кое-что, что мы должны сделать, чтобы взять нашу работу и перенести ее в github. В этот момент мне нравится переключаться между ветвями. Помните: github только служит из gh-страниц, и если вы следовали до сих пор, ваша ветка называется «хозяином». Давайте создадим новую (локальную) ветвь gh-pages.

`git checkout -b gh-pages` создаст его, скопирует всю работу с мастера на gh-страницы и переключит на ветку. Уф.

`git branch -d master` избавится от основной ветви. Звучит сумасшедшим, я знаю, но для чего нам это нужно? Подумайте о gh-страницах как о своей новой ветке.

Теперь `git add -A` и `git commit -m 'relevant message'` снова, на всякий случай. И будьте готовы оставить свой редактор и терминал и выйти в онлайн в первый раз.

Перейдите в свой профиль github и создайте новое репо. Назовите его чем-то соответствующим, например campNews.

![Новый репо](//discourse-user-assets.s3.amazonaws.com/original/2X/3/3f113af87b94fcd649c78d5f6d36463795671e7b.png)

После его создания зайдите и возьмите URL-адрес клона HTTPS. (Игнорируйте файлы на моем снимке экрана, ваше репо будет пустым на этом этапе).

![клон-код](//discourse-user-assets.s3.amazonaws.com/original/2X/a/a0f3da26ba0802342d7d6f7890763a2bca32b62a.png)

## Объединяя все это

И вы можете покинуть мир онлайн. Вернемся к терминалу! Давайте свяжем наш локальный проект с этим реестром github. Все, что требуется, - это одна команда.

`git remote add origin <server>` Просто замените сервер URL-адресом HTTPS, который вы только что скопировали. Поэтому моя команда выглядит так:

`git remote add origin https://github.com/gkobilansky/campNews.git` .

Хорошо, до сих пор мы имеем:

1.  Создал наш проект
2.  Вершился в git
3.  Принял некоторые изменения
4.  Переключил его на ветвь «gh-pages»
5.  Подключил его к github

## Последний шаг!

Направьте проект на github. Опять же, просто:

`git push origin gh-pages`

Эта команда гарантирует, что ваши последние коммиты будут загружены в github. Как только вы это сделали хотя бы один раз, ваш проект должен быть доступен http: // _username_ .github.io / _repository_ , поэтому для меня это [http://gkobilansky.github.io/campNews](http://gkobilansky.github.io/campNews) .

Как только это все будет сделано, процесс просто повторится:

1.  `git add -A`
2.  `git commit -m 'relevant message'`
3.  `git push origin gh-pages`

Конечно, более крутая кривая обучения, чем codepen.io, но более быстрая и гибкая, как только вы ее повесите.

Счастливое кодирование!

PS. Благодаря [этому руководству](http://rogerdudler.github.io/git-guide/) Роджер Дадлер, чтобы все было просто.
