---
title: What Is Clojure
localeTitle: Что такое Clojure
---
## Clojure - это диалект Лиспа.

Lisps - это совершенно отдельное семейство языков для C-подобных языков, таких как C #, Javascript, Python или Ruby. Это означает, что Lisps может показаться странным для программистов, которые более знакомы с этими языками. По сути, быть Lisp означает, что все в Clojure - это список, содержащий данные (даже вызовы функций!), Он имеет динамическую типизацию, и вы можете определить _макросы,_ которые позволят вам манипулировать вашим собственным кодом. Вот простой пример некоторых Clojure для вас:
```
   (defn hello-world [] (println "Hello world!")) 
```

Это определяет функцию (с использованием макроса `defn` ), называемую `hello-world` которая не принимает входных данных ( `[]` ) и печатает `"Hello world!"` на консоль. Мы можем назвать это так:
```
   (hello-world) 
   ; => Hello world! 
   ;    nil 
```

## Clojure - функциональный язык.

Все переменные в Clojure неизменяемы и не могут быть изменены с использованием оператора присваивания ( `=` на большинстве C-подобных языков) или с помощью функции. Все функции направлены на _прозрачность_ , что означает, что если вы даете им тот же ввод, они должны давать одинаковый результат независимо от того, что. Пример `hello-world` выше ссылочно прозрачен - он всегда будет печатать «Hello world!». не важно что. То, что полагается на генератор случайных чисел, не является ссылочно прозрачным, потому что его вывод случайный.
```
  (defn random-function [] 
    (if (> (rand 4) 2)     ; if a random number between 0 and 2 is greater than 2... 
      (println "foo")      ; ...print "foo". otherwise... 
      (println "bar")))    ; ...print "bar" 
```

Хотя неспособность изменять переменные может казаться кошмаром, это намного проще, чем вы думаете, особенно если язык основан на нем (например, Clojure is!), И, избегая ненужной мутации, вы можете сделать код намного менее ошибочным.

## Clojure работает на виртуальной машине Java.

JVM - это виртуальная машина, которая интерпретирует байт-код Java и использует ее для запуска программы. Это означает, что Clojure работает практически без кода, разработанного для Java (хотя это выглядит немного странно), а также означает, что он работает довольно быстро по сравнению с некоторыми другими Lisps. Хотя он довольно медленный, чем Java, он все еще намного быстрее, чем Python, Ruby или Javascript.
```
  (.indexOf [1 2 3 4] 2) ;; .indexOf is a Java method! 
  ; => 1 
```

## Clojure предназначен для параллелизма.

«Параллелизм» здесь означает «одна программа, работающая сразу с несколькими потоками», которая может сделать ваш код намного быстрее. Он также может сделать ваш код намного более сложным; предположите, что две разные функции менялись и читали один и тот же объект сразу! Это был бы полный хаос. К счастью, в Clojure переменные неизменны, а это означает, что нет никаких шансов на то, что этот вид хаоса сломается. Язык также обладает множеством функций для упрощения параллельного кода, такого как система транзакционной памяти программного обеспечения, агенты и атомы.

| ![:point_left:](//forum.freecodecamp.com/images/emoji/emoji_one/point_left.png?v=2 ": Point_left:") Предыдущая | [![:book:](//forum.freecodecamp.com/images/emoji/emoji_one/book.png?v=2 ":книга:") Главная ![:book:](//forum.freecodecamp.com/images/emoji/emoji_one/book.png?v=2 ":книга:")](//forum.freecodecamp.com/t/clojure-resources/18422) | [следующий ![:point_right:](//forum.freecodecamp.com/images/emoji/emoji_one/point_right.png?v=2 ": Point_right:")](//forum.freecodecamp.com/t/clojure-the-basics/18410) |  
| | [Содержание](//forum.freecodecamp.com/t/clojure-resources/18422) | [Основы](//forum.freecodecamp.com/t/clojure-the-basics/18410) |