---
title: When to Undoredo
localeTitle: Когда до Undoredo
---
Обычно вы хотите использовать UNDO / REDO, когда вы совершаете некоторые изменения в git, и понимаете, что изменения необходимо удалить / вернуть. Это очень распространено в сценариях, например, когда вы делали временные изменения в некоторых файлах и забывали их вернуть, а затем приступили к их добавлению к ошибке.

## Рабочий процесс UNDO / REDO:

Предполагая, что вы внесли некоторые изменения и совершили такие действия, как:
```
git commit -m "Commit 1 - Some changes to the code" 
 git commit -m "Commit 2 - Some MORE changes to the code" 
```

1.  (UNDO-ing): вернуть обратно последнюю команду `git reset --soft HEAD~`
2.  _Сделайте изменения._
3.  Добавьте свои файлы в промежуточную область `git add <filenames or paths>` или `git add --all`
4.  (REDO-ing): выполнить фиксацию. `git commit -c ORIG_HEAD` или `git commit -C ORIG_HEAD`

## Как это работает?

Теперь, когда вы знаете, что поток позволяет понять, как это работает за кулисами.

1.  `Step 1` сбрасывает последнюю фиксацию, т.е. `"Commit 2 - Some MORE..."` обратно в фиксацию `"Commit 1 - Some..."` .
2.  На `Step 2` вы делаете изменения, которые вы сочтете подходящими для файлов.
3.  На `Step 3` вы добавляете измененные файлы в промежуточную область либо выборочно с `git add <filenames>` либо все файлы с `git add --all` .
4.  На последнем этапе вы совершаете изменения в промежуточной области.

Примечание: вы можете использовать `-c` или `-C` . Маленький `-c` откроет редактор для модификации сообщения фиксации, в этом случае это будет `Commit 2 - Some MORE...` Вы можете редактировать сообщение фиксации так, как хотите.

Или, альтернативно, вы можете использовать caps `-C` , где git пропускает окно редактора и повторно использует сообщение _LAST_ commit, которое в этом случае является `Commit 2 - Some MORE...`

Повторное использование сообщения «То же» фиксации также известно как повторное / повторное выполнение.

## Неэксплуатация перед фиксацией

Чтобы отменить изменение, поставленное перед фиксацией, просто запустите `git reset <file>` или `git reset` чтобы отключить все изменения до фиксации.

Примечание. В более старых версиях git команды были `git reset HEAD <file>` и `git reset HEAD` соответственно. Это было изменено в Git 1.8.2

## Некоторые дополнительные трюки:

Вы можете возвратить любое количество `git reset --soft HEAD~n` используя `git reset --soft HEAD~n` где вы хотите отменить последние `n` коммитов.

## Attribution:

Эта статья основана на вопросе переполнения стека [здесь](http://stackoverflow.com/questions/927358/how-do-you-undo-the-last-commit/927386#927386) и [здесь](http://stackoverflow.com/questions/348170/undo-git-add-before-commit/348234#348234) .