---
title: Writing a Markdown File for GitHub Using Atom
localeTitle: Запись файла Markdown для GitHub с помощью Atom
---
Markdown - способ стилизации текста в Интернете, а пользователи GitHub используют уценку для предоставления документации для своих репозиториев.

Из [руководства GitHub](https://guides.github.com/features/mastering-markdown/) :

> Вы контролируете отображение документа; форматирование слов жирным шрифтом или курсивом, добавление изображений и создание списков - вот лишь некоторые из вещей, которые мы можем сделать с Markdown. В основном, Markdown - это обычный текст с несколькими неалфавитными символами, добавленными, например, # или \*.
> 
> Вы можете использовать Markdown в большинстве мест вокруг GitHub:
> 
> *   Суть
> *   Комментарии в разделе «Вопросы и запросы»
> *   Файлы с расширением .md или .markdown
> 
> У файлов Markdown есть расширение `.md` и вы увидите, что огромное количество репозиториев GitHub имеют файлы `README.md` .

Отличным примером является то, что если вы хотите написать Wiki-файл для этого репозитория, это должен быть файл `.md` . То, что вы сейчас читаете, - это файл `writing-a-markdown-file-using-atom.md` называемый `writing-a-markdown-file-using-atom.md` .

Markdown файлы легко писать, и вы можете найти шпаргалку уценки [здесь](https://github.com/adam-p/markdown-here/wiki/Markdown-Cheatsheet) .

## Создание файла readme на GitHub

Вы можете создать файл README.md на самом GitHub:

![скриншот 2016-02-29 в 18 07 19](//discourse-user-assets.s3.amazonaws.com/original/2X/9/9a1d7f226df87df437f616fcaf5b7adcf02c8e87.png)

Это дает вам возможность переключаться между видами «Редактировать новый файл» и «Предварительный просмотр»:

![скриншот 2016-02-29 в 18 06 24](//discourse-user-assets.s3.amazonaws.com/original/2X/e/e0b3ddb69c3f2c32c0c7e73f1b1d196a54f03c21.png)

Это идеально, если ваш файл readme невелик, и вы не против переключения между двумя видами.

Но что, если ваш `.md` файл не является readme, и вы хотите роскошь работать в текстовом редакторе и просматривать предварительный просмотр того, как выглядит ваш текст, в то же время, когда вы его редактируете?

## Запись файлов Markdown с помощью Atom

Если вы пишете длинный или подробный файл разметки, это помогает получить предварительный просмотр в реальном времени именно того, как выглядит ваша уценка, точно так же, как вы можете использовать возможности живой перезагрузки для обновления вашего браузера, если вы работаете над проектом который использует HTML и CSS, например.

Хороший способ создания файла markdown использует [текстовый редактор Atom](https://atom.io/) . Вы можете установить и использовать Atom бесплатно.

Atom, как и другие текстовые редакторы, использует пакеты, которые представляют собой фрагменты кода, которые позволяют настраивать рабочий процесс.  
1\. Во-первых, вы захотите установить текстовый редактор Atom [здесь](https://atom.io/) .  
2\. Когда Atom установлен, откройте его и откройте новый файл с расширением `.md` .  
3\. Чтобы просмотреть предварительный просмотр в прямом эфире, щелкните правой кнопкой мыши ваш `.md` файл из проводника слева, а затем выберите верхний вариант «Предварительный просмотр графика»:

![скриншот 2016-02-29 в 18 17 30](//discourse-user-assets.s3.amazonaws.com/original/2X/e/ea3746446180c0e0ad2bb61f30a6c3ad8bc25c57.png)

Круто! Теперь вы должны увидеть две панели в Atom. Слева - ваш текст, а справа - ваша «скомпилированная» уценка, то есть, как это выглядит на GitHub:

![скриншот 2016-02-29 в 18 21 38](//discourse-user-assets.s3.amazonaws.com/original/2X/a/a1f27aa8afe060e252f245ced3456f196c85ef1b.png)

Обратите внимание, что Atom также распознает, с чем вы работаете, чтобы быть конкретным форматом, то есть «GitHub Markdown»:

![скриншот 2016-02-29 в 19 15 43](//discourse-user-assets.s3.amazonaws.com/original/2X/c/cf5b2fc473c32a14a2de302fd88e4c2edde02453.png)

1.  Когда ваш файл уценки готов к фиксации в вашем репозитории GitHub, вы можете продолжить и зафиксировать его!

Чтобы внести вклад в вики FreeCodeCamp, перейдите на [эту страницу](https://github.com/FreeCodeCamp/freecodecamp/wiki) и ознакомьтесь с разделом «Руководства о том, как внести вклад».

Чтобы добавить проект или файлы в GitHub, перейдите на [эту страницу](https://help.github.com/articles/adding-an-existing-project-to-github-using-the-command-line/) .

**Шаг бонуса: у** Atom есть пакет с именем [Markdown Preview Plus](https://atom.io/packages/markdown-preview-plus) . Он делает то же самое, что и обычный предварительный просмотр markdown, но файл предварительного просмотра более точно применяется к стилю GitHub. Идите и установите этот пакет и посмотрите, что вы получите.
