---
title: Writing Good Git Commit Messages
localeTitle: Написание хороших сообщений Git Commit
---
1.  Отдельный объект из тела с пустой строкой
2.  Ограничьте строку темы до 50 символов
3.  Заглавие строки темы
4.  Не завершайте строку темы с периодом
5.  Используйте императивное настроение в строке темы
6.  Оберните тело 72 символами
7.  Используйте тело, чтобы объяснить, что и почему против

**Правильно сформированная строка темы git commit должна всегда иметь возможность выполнить следующее предложение:**

> Если это применимо, эта фиксация будет _`<<your subject line here>>`_

**Например:**

*   Если применяется, это фиксация будет **_подсистемой X Refactor для удобочитаемости_**
*   Если применяется, эта фиксация **_обновит начальную документацию_**
*   Если применяется, эта фиксация будет **_удалять устаревшие методы_**
*   Если применяется, этот коммит будет **_выпущен версии 1.0.0_**
*   Если применяется, эта фиксация будет **_объединять запрос на вывод № 123 от пользователя / ветки_**

**Обратите внимание, что это не работает для других неимперативных форм:**

*   Если применяется, эта фиксация будет _исправлена ​​ошибка с Y_
*   Если применяется, это коммит будет _изменять поведение X_
*   Если применяется, это фиксация будет _больше исправления для сломанных вещей_
*   Если применить этот коммит, будут применены _новые методы API_

**Помните:** _использование императива важно только в строке темы. Вы можете смягчить это ограничение, когда пишете тело._

**Ссылка:** [http://chris.beams.io/posts/git-commit](http://chris.beams.io/posts/git-commit)