---
title: Cordova iOS Application Development Setup to Deployment
localeTitle: Настройка разработки приложений в Кордове iOS для развертывания
---
# Настройка разработки приложений в Кордове iOS для развертывания

![iphone_1737513_1920](https://image.ibb.co/iKCSuQ/Xz_J197k8_QI32.jpg)

Разработка гибридных приложений для Android очень велик, будь то разработка или конфигурация производства, однако я лично считаю, что установка, разработка и развертывание IOS кордоны немного сложнее.

Большинство разработчиков гибридных приложений, которые учатся на этапе обучения, не могут исследовать процесс разработки приложений для гибридных iOS по простой причине, что они не владеют Mac, поскольку для разработки приложений для iOS требуется iOS SDK и XCode, в отличие от Android SDK, который работает на любом Настольная ОС. Поэтому целью этого руководства является показать основной рабочий процесс разработки гибридных приложений iOS на Mac, так что разработчик, даже если он / она не может разрабатывать приложения для iOS, по крайней мере знаком с его выполнением.

## Создание проекта cordova

Начните с открытия терминала и создания нового проекта cordova (используйте sudo, только если у вас есть проблемы с разрешением, то есть ошибки EACCESS):
```
sudo cordova create iosdemo 
 cd iosdemo 
 sudo cordova platform add ios 
```

На момент написания этой версии руководство по программированию на платформе iOS: 4.3.1

Мы не будем изменять какой-либо исходный код приложения и просто продолжаем с образцом кода по умолчанию, который автоматически добавляется кордорой, когда мы запускаем команду create. Однако предполагается, что мы добавим плагины для изменения кода в папке `www` во время нормального потока разработки.

Следующий шаг - запустить команду сборки cordova. Это преобразует наш код приложения в файл .xcodeproj, который мы будем использовать далее.
```
sudo cordova build ios 
```

Сгенерированный файл проекта Xcode будет находиться в:
```
[Your App Folder]/platforms/ios/[Your App Name].xcodeproj 
```

Теперь под Android, подписание кода выполняется с помощью файла Keystore, который находится в формате .jks. Однако для iOS для распространения приложений iOS требуется, чтобы у вас была учетная запись разработчика Apple, Это значит, что мы можем создавать _сертификаты_ и _профили Provisioning Profiles,_ необходимые для распространения приложения.

Для оценки учетной записи разработчика см. [Эту страницу](https://developer.apple.com/support/purchase-activation/)

## Создание сертификатов разработки

После того, как у вас будет готов аккаунт, мы можем продолжить работу и войти в [аккаунт разработчика Apple](https://developer.apple.com/account/)

Экран панели инструментов должен выглядеть примерно так: ![Открытие проекта в Xcode](https://image.ibb.co/j0d8zQ/Clipboard_image_2017_09_18_11_35_58.png)

Нажмите « `Certificates, Identifiers & Profiles` Это приведет вас к следующему экрану, который по умолчанию отображает сертификаты, выпущенные из вашей учетной записи: ![Сертификаты, идентификаторы и профили](https://image.ibb.co/fk8mm5/1.png)

IOS Certficates имеют в основном два типа: «Разработка или распространение», нажмите кнопку «Плюс» (+) в правом верхнем углу списка, которая откроет следующую страницу: ![Добавить сертификат iOS](https://image.ibb.co/dksXtk/2.png)

Сначала создадим профиль развития: Выберите « _Разработка приложений для iOS»_ и нажмите «Продолжить».

Это приведет вас к следующему экрану, где вас попросят создать и загрузить запрос на подпись сертификата или файл CSR. ![Загрузить файл CSR](https://image.ibb.co/iwBE65/3.png)

Следуйте инструкциям на экране, чтобы сгенерировать их, и продолжайте. Как только сертификат будет готов, загрузите его на свой Mac и дважды щелкните по нему. Это добавит его в Keychain Access на Mac. ![Загрузить сертификат разработки](https://image.ibb.co/dJg6m5/4.png)

## Создание сертификатов распространения

Создание сертификатов распространения аналогично процессу создания сертификатов разработки, Однако здесь мы выбираем раздел `App Store and Ad Hoc` из раздела `Production` на `Add iOS Certifcate Page`

![Добавить сертификат iOS](https://image.ibb.co/bEKFeQ/5.png)

## Создание идентификатора приложения

Выберите раздел « `Identifiers` `App IDs` из `Identifiers` », это откроет список существующих идентификаторов приложений, Затем нажмите кнопку «Плюс» в правом верхнем углу (+), откроется страница « _Регистрировать идентификаторы приложений iOS»_ .

![Зарегистрировать идентификаторы приложений iOS](https://image.ibb.co/iXTuOk/6.png)

Выберите Явный идентификатор приложения

Описание приложения может быть любым связанным именем, которое будет отображаться в списке идентификаторов приложения против конкретного идентификатора приложения.

Идентификатор приложения - это строка в формате _AB11A1ABCD.com.mycompany.myapp,_ где _AB11A1ABCD_ - это префикс идентификатора приложения, по умолчанию идентификатор команды и _com.mycompany.myapp_ - это идентификатор пакета, который является уникальным для каждого приложения. Он рекомендовал, чтобы идентификатор пакета должен быть в строке стиля имени в обратном домене, например, компания MYCOMPANY может иметь два приложения (App1 и App2), поэтому http-url для каждого приложения обычно является app1.mycompany.com и app2.mycompany .com, Следовательно, идентификаторы связки для каждого приложения будут com.mycompany.app1 и com.mycompany.app2

Затем выберите любые службы из списка chceklist, которые необходимо использовать в вашем приложении, например Push Notifications, Wallet и т. Д. Затем нажмите «Продолжить» и подтвердите данные и, наконец, зарегистрируйте идентификатор приложения.

## Добавление устройств в аккаунт разработчика

Выберите « `All` из `Devices` », это откроет список уже добавленных устройств на вашу учетную запись разработчика Apple, Только этим устройствам разрешено запускать приложение во время разработки. Чтобы добавить новое устройство Далее нажмите кнопку «Плюс» в правом верхнем углу (+) Появится следующий экран: ![добавить экран устройства](https://image.ibb.co/gTmW3k/8.png)

Здесь имя может быть любым легко выполнимым примером имени, iPhone 5s ABC Pvt Ltd. UDID устройства - это уникальный идентификатор, связанный с каждым устройством Apple.

Чтобы найти UDID устройства, выполните следующие шаги: 1) Подключите устройство к компьютеру Mac. 2) Откройте приложение System Information, расположенное в папке / Applications / Utilities. 3) Выберите USB под аппаратным обеспечением в левом столбце. 4\_ Справа выберите подключенное устройство под деревом устройств USB. Идентификатор устройства или «Серийный номер» отображается ниже.

После того, как вы ввели UDID устройства и имя, нажмите «Продолжить», затем подтвердите данные и зарегистрируйтесь.

## Создание профиля разработки

Чтобы создать профиль Provisioning Profile, нажмите «Provisioning Profiles» -> All Это должно показать все профили, развитие, а также распространение. Затем нажмите кнопку «Плюс» в правом верхнем углу (+) Это должно показать следующую страницу: ![Создание профиля обеспечения разработки](https://image.ibb.co/dk3KOk/7.png)

Здесь выберите « `iOS App Development` и нажмите «Продолжить». В раскрывающемся списке выберите идентификатор приложения, который мы создали ранее, и продолжим.

Далее Отображается список контрольных списков сертификатов, из которых мы можем выбрать один или несколько. Это сертификаты разработки, а не дистрибутивные. Сгенерированный профиль подготовки будет связан с этими сертификатами.

При щелчке по кнопке continue отобразится контрольный список устройств, выберите один, несколько или все. Только выбранные устройства могут запускать приложение, используя этот профиль подготовки.

Затем нажмите «Продолжить», введите имя профиля предоставления и загрузите сгенерированный файл .mobileprovision.

## Создание профиля распределения распределения Adhoc

Этот процесс такой же, как создание профиля разработки

## Создание профиля размещения дистрибутива AppStore

Этот процесс аналогичен созданию профиля разработки, за исключением того, что мы не выбираем устройства, так как приложение будет доступно публично через AppStore.

Теперь, когда у нас есть все, что нам нужно, мы можем продолжать генерировать фактический ipa с помощью Xcode.

_Примечание: команда cordova build преобразует наш код приложения в проект xcode, используя Xcode, мы создаем файл .ipa, который является фактическим приложением для установки._

* * *

прежде чем двигаться вперед, дважды нажмите на оба сертификата, чтобы добавить их в брелок

## Продолжение в Xcode

Затем дважды коснитесь файла .xcodeproj, который должен открыть его в Xcode. (Пожалуйста, используйте последнюю версию Xcode, я использовал Xcode 8.3.2)

![Открытие проекта в Xcode](https://image.ibb.co/mPdGKQ/Screen_Shot_2017_09_18_at_11_06_55_AM.png) Экран Xcode должен выглядеть примерно так.

Нажмите на имя приложения в верхнем левом углу окна, это откроет подробный вид с правой стороны. ![Настройки проекта](https://image.ibb.co/fqb3ZQ/Screen_Shot_2017_09_18_at_5_07_53_PM.png)

Затем нажмите «Цели» -> «Имя приложения»

![цели](https://image.ibb.co/i0znTk/Screen_Shot_2017_09_18_at_5_11_28_PM.png)

На этой вкладке отобразится следующая информация: ![сведения о цели](https://image.ibb.co/ksBj8k/Screen_Shot_2017_09_18_at_5_15_29_PM.png)

Clik on general, который должен отображать: ![общие сведения](https://image.ibb.co/k8KFEQ/Screen_Shot_2017_09_18_at_5_18_29_PM.png)

Снимите флажок «Автоматически управлять подписью»

Это должно отображать следующую ошибку, заявляя, что AppNAme требует профилирования ![ошибка профиля](https://image.ibb.co/mDq5EQ/Screen_Shot_2017_09_18_at_5_20_35_PM.png)

Затем в разделе Подписание (отладка) Выберите _раскрывающийся профиль Профилирования_ и выберите _опцию профиля импорта_ . В появившемся диалоговом окне выбора файла перейдите к пути, в котором загружен профиль определения разработки, и выберите его. Он будет иметь расширение _.mobileprovision_

После выбора ошибка должна исчезнуть, и она должна отображать Team как имя команды в учетной записи Apple eveloper и имя сертификата подписи.

Сделайте то же самое для раздела Signing (Release), однако в диалоговом окне выбора файла выберите профиль распределения Ad Hoc.

Теперь, когда шаги подписи кода выполняются, мы либо

*   запустите приложение прямо на устройстве
*   запустить приложение на симуляторе
*   генерировать ipa-файл для распространения
*   загрузить приложение в appstore

## Запуск приложения непосредственно на устройстве

Чтобы запустить приложение на устройстве, подключите устройство к Mac через USB, затем в верхнем левом углу списка устройств выберите подключенное устройство и нажмите кнопку запуска или воспроизведения (черная треугольная кнопка) ![запустить устройство](https://image.ibb.co/k4xo15/Screen_Shot_2017_09_18_at_5_34_14_PM.png) ![запустить устройство](https://image.ibb.co/hjzhuQ/Screen_Shot_2017_09_18_at_5_36_55_PM.png)

Состояние сборки будет отображаться в строке состояния в верхней части окна. Если все будет хорошо, приложение должно быть установлено на устройстве и автоматически загружаться через некоторое время.

## Запуск приложения на симуляторе

Шаги такие же, как и на устройстве, но вместо реального устройства мы используем доступные симуляторы iPhone и iPad из списка устройств.

## Создайте файл ipa для распространения

Этот подход может быть выполнен в случае, если вам требуется распространять приложение для группы тестирования и т. Д. Однако используемое ими устройство должно иметь UDID, присутствующий в профиле подготовки.

В меню Xcode выберите « `Product` -> « `Clean` , Затем `Product` -> `Archive` , Появится организатор архивов и отобразит новый архив. ![организатор архива ios](https://image.ibb.co/iunfMG/6_ios_archive_organizer_2x.png) На правой боковой панели выберите вариант «Экспорт», появится значок optios.

Чтобы распространить ваше приложение на пользователей с указанными устройствами, выберите «Сохранить для развертывания ad hoc». Приложение будет подписано кодом с сертификатом распространения.

Чтобы распространить ваше приложение для внутреннего тестирования, выберите «Сохранить для развертывания разработки». Приложение будет подписано кодом с вашим сертификатом разработки. ![Экспорт организатора экспорта ios в виде ad hoc](https://image.ibb.co/jQJLMG/6_ios_createappstorepackage_1_2x.png)

В появившемся диалоговом окне выберите команду во всплывающем меню и нажмите «Выбрать». ![Команда выбора экспорта ios](https://image.ibb.co/gH2VMG/6_ios_export_choose_team_2x.png)

Затем открывается диалоговое окно выбора устройства Выберите « _Все устройства»_ или « _Специальные устройства»,_ нажмите «Далее».

Затем отобразится диалоговое окно обзора, Здесь он покажет сертификат подписи и профиль обеспечения, используемые для создания сборки. Просмотрите и нажмите «Далее». Наконец, файл сохраняет как всплывающее окно, чтобы выбрать местоположение в файловой системе для хранения экспортированного файла приложения.

Приложение экспортируется как файл \`.ipa\`\`\`.

Чтобы запустить этот файл на устройстве, просто дважды нажмите его, чтобы открыть его в itunes.

Затем подключите свое устройство (в этом окне должен отображаться значок небольшого устройства в верхнем левом углу окна itunes) нажав на него, вы увидите сводку устройства, такую ​​как приложения, музыка и т. д. на устройстве. Выберите вкладку приложений, в левой панели выберите приложение для установки и нажмите «Установить». Дождитесь завершения процесса и нажмите «Применить», Это должно установить ipa-файл на вашем устройстве.

Чтобы отладить приложение: 1) Открытое сафари, 2) откройте приложение на устройстве 3) В строке меню Safari выберите « `Develop --> Your Device Name --> Your App` .

## Это все люди !!!