---
title: Mobile app development
localeTitle: Разработка мобильных приложений
---
### Введение в разработку приложений

Одной из наиболее популярных форм кодирования в последнее время является создание приложений или приложений, работающих на мобильных устройствах, таких как телефоны и планшеты. Вероятно, вы используете целый ряд различных приложений в своей повседневной жизни. Не было бы здорово создать свою собственную? Есть много льгот быть разработчиком в быстро развивающейся индустрии приложений. Довольно много людей хорошо развивают и продают приложения, и у вас есть возможность стать одним из них. Вы даже можете стать следующим Nick D'Aloisio, который знаменито продал свое приложение для iPhone, Summly, Yahoo! за 30 миллионов долларов. Кроме того, это лучший способ получить работу в карманах людей!

### Обзор разработки приложений

Мобильные приложения разработаны для определенной платформы, а двумя самыми популярными платформами сегодня являются iOS и Android. Платформа iOS поддерживает приложения, созданные для iPhone и iPad. Чтобы разработать приложение для iPhone или iPad, вам необходимо использовать язык кодирования Objective-C и структуру Cocoa. Вам также необходимо использовать среду IDE (интегрированную среду разработки) под названием Xcode. Обратите внимание, что Xcode работает только на Mac, поэтому вам понадобится Mac для создания приложения iOS. Приложения Android разрабатываются с использованием языка программирования Java и набора для разработки программного обеспечения для Android, который работает на Mac, ПК или Linux. Вам также необходимо использовать IDE, например Eclipse. Существуют и другие мобильные платформы, такие как Windows Phone, но iOS и Android, безусловно, являются самыми популярными. Большинство тренингов сосредоточено на этих платформах.

#### iOS (iPhone, iPad)

iOS - это мобильная операционная система, разработанная и распространяемая Apple Inc. Она была первоначально выпущена в 2007 году для iPhone, iPod Touch и Apple TV. iOS получена из OS X, с которой он разделяет фонд Дарвина. iOS - это мобильная версия операционной системы OS X от Apple, используемая на компьютерах Apple.

#### ионный

Ionic - это платформа с открытым исходным кодом, используемая для разработки мобильных приложений. Он предоставляет инструменты и услуги для создания мобильного интерфейса с естественным внешним видом. Ионной структуре требуется встроенная оболочка для работы на мобильных устройствах. Это вводный учебник, в котором рассказывается об основах Ionic Open Source Framework и объясняется, как работать с его различными компонентами и подкомпонентами.

#### Android

Android - это операционная система с открытым исходным кодом и Linux для мобильных устройств, таких как смартфоны и планшетные компьютеры. Android был разработан Open Handset Alliance под руководством Google и других компаний. Этот учебник научит вас базовому программированию на Android, а также рассмотрит некоторые предварительные концепции, связанные с разработкой приложений Android.

#### Xamarin

Xamarin - это программная компания, базирующаяся в Сан-Франциско. Он предоставляет коммерческие инструменты для разработки программного обеспечения, которые позволяют пользователю разрабатывать приложения для Android, iOS и Windows с использованием языка C # и платформы .NET. Xamarin построен на платформе .NET Framework. Это позволяет создавать приложения, которые легко запускаются на нескольких платформах. В этом уроке мы объясним, как вы можете использовать Xamarin для доставки родных приложений для iOS, Android и Windows.

#### PhoneGap

PhoneGap - это система разработки программного обеспечения Adobe System, которая используется для разработки мобильных приложений. Чтобы разрабатывать приложения с помощью PhoneGap, разработчику не требуется знание языка программирования для мобильных устройств, но только языки веб-разработки, такие как HTML, CSS и JScript. PhoneGap производит приложения для всех популярных мобильных платформ ОС, таких как iOS, Android, BlackBerry и Windows Mobile OS. В этом уроке мы сосредоточимся на разработке приложения для платформы Android. В этом руководстве вы получите адекватную информацию о том, как быстро создавать приложения, используя службы PhoneGap.

#### Реагировать на родной

React Native так же, как PhoneGap, и кордова дает возможность веб-разработчикам выйти в мир Mobile App Development. Это платформа для мобильных приложений с перекрестной платформой от Facebook i, e можно создавать приложения для платформы Android и ios с помощью Javascript (JSX). В отличие от этих гибридных приложений, созданных кордовой и телефонной связью, React Native выпускает настоящие родные приложения, которые могут использовать все собственные функции. Он поставляется с слоганом: «Пишите один раз, бегите везде». Обычно у компаний Tech были отдельные команды, которые поддерживали бы кодовую базу для ios и android. React Native эффективно решает эту проблему, позволяя веб-разработчикам с React background создавать потрясающие мобильные приложения. Чтобы продолжить этот трек, начните с React. Перед тем, как перейти в React Native, вы должны быть знакомы со всеми этими концепциями, такими как компоненты, состояния, реквизиты, маршрутизация и т. Д. Также хорошо, если вы можете создать кучу проектов в React, чтобы ознакомиться с синтаксисом JSX и всеми другими материалами, которые, несомненно, выиграют, когда они появятся в React Native.

#### PowerApps

PowerApps, запущенная в 2017 году, является платформой на базе браузера от Microsoft, которая позволяет разработчикам и не-разработчикам создавать мобильные приложения из выбираемых шаблонов или из чистого холста. PowerApps по своей сути является платформой как услугой. Он позволяет создавать мобильные приложения, которые работают на Android, iOS, Windows (современные приложения), и практически с любым интернет-браузером. Он заботится о различиях между операционными системами и просто позволяет запускать ваши приложения. По сути, это контейнер, который упрощает использование мобильных приложений на мобильных платформах. PowerApps предлагает значительно ускорить создание бизнес-приложений, сокращая время до решения с недель или месяцев до минут и предоставляя новую категорию создателей приложений.