---
title: OSI Layers 
localeTitle: OSI Layers 
---
## Слои OSI

### Введение

Вы когда-нибудь задумывались, как данные отправляются через сеть с одной машины на другую? Если да, то модель Open System Interconnected - это то, что вы ищете.

Модель OSI используется для стандартизации и характеристики того, как данные должны поступать от отправителя к получателю без учета внутренней внутренней структуры конечной точки (отправителя, получателя).

Организация, которая придумала эту модель, является **Международной организацией по стандартизации,** и поэтому эта модель официально называется **ISO-OSI** .

### Архитектура

Как и на рисунке ниже, модель делит сеть на **7 слоев** . Передача данных в модели OSI начинается с верхнего уровня (уровня приложения) стека со стороны отправки, перемещается вниз по стеку до самого низкого уровня отправителя (физический уровень), а затем проходит физическое сетевое соединение с нижним уровнем на принимающем и вверх по его стеку модели OSI.

Мы используем многоуровневый подход, потому что легко создавать независимые слои с выделенными функциями, которые взаимодействуют друг с другом по сравнению с одной сложной моделью.

![Связь между отправителем, промежуточными узлами и получателем через несколько уровней](https://user-images.githubusercontent.com/16820612/33828192-2773b920-de91-11e7-8804-08dbfaf0143a.jpg)

### **Важные наблюдения**

*   _**Сквозные слои:**_ На приведенной выше диаграмме вы заметите, что верхние уровни протокола (Application-Transport), уровни отправителя и получателя напрямую связаны через стрелки. Это связано с тем, что эти уровни не знают о промежуточных устройствах, которые используются для передачи данных (таких как коммутаторы и маршрутизаторы). Кажется, что эти слои общаются напрямую друг с другом.
    
*   _**Единица данных:**_ На приведенной выше диаграмме крайняя левая часть - это единица данных, которая используется в каждом слое. Транспортный слой (и слои ниже него) имеют уникальное имя для единицы данных, передаваемых от отправителя к получателю.
    

### **Функции слоев**

*   _**Уровень 1 - Физический уровень:**_ физический уровень является самым низким из слоев OSI и наиболее сложным. Это происходит из-за используемых аппаратных технологий. Функция этого уровня заключается в определении того, как будет передаваться поток бит, а не в пакет логических данных. Он посвящен определению, на какой частоте будет передаваться бит, какая будет модуляция, как будут группироваться биты и другие низколежащие физические параметры, необходимые для передачи бит.
    
*   _**Уровень 2 - Уровень канала передачи**_ данных. Уровень передачи данных отвечает за передачу данных соседним устройствам в одной локальной сети (LAN). Этот слой также имеет положения, гарантирующие, что безошибочные данные передаются на более высокие уровни с физического уровня. Следовательно, он обеспечивает механизмы обнаружения ошибок и коррекции для обеспечения целостности данных.
    
*   _**Уровень 3 - Сетевой уровень**_ . Сетевой уровень отвечает за пересылку пакетов в другие сети. Обычно сеть разделяется на несколько подсетей, а сетевой уровень с помощью маршрутизаторов пересылает пакеты между такими сетями для создания глобальной сети (WAN).
    
*   _**Уровень 4 - Транспортный уровень**_ . Транспортный уровень гарантирует, что сообщения доставляются без ошибок, последовательно и без потерь или дублирования. Он освобождает протоколы более высокого уровня от любых проблем с передачей данных между ними и их сверстниками.
    
*   _**Уровень 5 - Уровень сеанса: уровень**_ сеанса позволяет установить сеанс между процессами, запущенными на разных станциях.
    
*   _**Слой 6 - Уровень презентации. Уровень**_ презентации форматирует данные, которые должны быть представлены на прикладном уровне.
    
*   _**Уровень 7 - Уровень приложения. Уровень**_ приложения служит для окна приложений для пользователей и приложений для доступа к сетевым службам.