---
title: Packets
localeTitle: Пакеты
---
## Пакеты

Пакет является базовой единицей связи по цифровой сети. Пакет также называется **дейтаграммой, сегментом, блоком, ячейкой или кадром, в** зависимости от протокола, используемого для передачи данных. Когда данные должны быть переданы, они разбиваются на аналогичные структуры данных перед передачей, называемые пакетами, которые повторно собираются в исходный блок данных, как только они достигают своего адресата.

Сети с коммутацией пакетов, как правило, более эффективны по сравнению с сетями с коммутацией каналов. Сеть с коммутацией каналов должна резервировать ресурсы на время связи. Сети с коммутацией пакетов могут отправлять пакеты по требованию.

В модели OSI пакеты соответствуют уровню 3 уровня сети.

## Структура пакета данных

Структура пакета зависит от типа пакета и протокола. Далее читайте далее о пакетах и ​​протоколах. Обычно пакет имеет заголовок и полезную нагрузку.

Заголовок сохраняет служебную информацию о пакете, услуге и других связанных с передачей данных. Например, передача данных через Интернет требует разбиения данных на IP-пакеты, которые определены в IP (Internet Protocol), а IP-пакет включает в себя:

*   IP-адрес источника, который является IP-адресом машины, отправляющей данные.
*   IP-адрес получателя, который является машиной или устройством, на которое отправляются данные.
*   Номер последовательности пакетов, число, которое помещает пакеты в порядок, чтобы они были собраны таким образом, чтобы вернуть исходные данные точно так же, как и до передачи.
*   Тип услуги.
*   Флаги.
*   Некоторые другие технические данные.
*   Полезная нагрузка, которая представляет основную часть пакета (все вышеперечисленное рассматривается как накладные расходы), и на самом деле данные переносятся.

## Пакеты и протоколы

Пакеты различаются по структуре и функциональности в зависимости от применяемых им протоколов. VoIP использует IP-протокол и, следовательно, IP-пакеты. Например, в сети Ethernet данные передаются в кадрах Ethernet.

В IP-протоколе IP-пакеты распространяются через Интернет через узлы, которые являются устройствами и маршрутизаторами (технически называемыми узлами в этом контексте), найденными на пути от источника до места назначения.

Каждый пакет маршрутизируется в направлении адресата на основе его исходного и целевого адресов. На каждом узле маршрутизатор решает на основе вычислений, включающих статистику сети и затраты, к которой соседний узел более эффективен для отправки пакета.

Этот выбранный узел более эффективен для отправки пакета. Это часть коммутации пакетов, которая фактически сбрасывает пакеты в Интернете, и каждый из них находит свой собственный путь к месту назначения. Этот механизм использует базовую структуру Интернета бесплатно, что является основной причиной того, что VoIP-звонки и интернет-звонки являются наиболее бесплатными или очень дешевыми.

В отличие от традиционной телефонии, где линия или схема между источником и пунктом назначения должны быть выделены и зарезервированы (так называемое коммутация каналов), следовательно, высокая стоимость, коммутация пакетов использует существующие сети бесплатно.

Другим примером является TCP (протокол управления передачей), который работает с IP в том, что мы называем набором TCP / IP. TCP отвечает за обеспечение надежной передачи данных. Для этого он проверяет, пришли ли пакеты в порядок, отсутствуют ли какие-либо пакеты или были ли они дублированы, и есть ли какая-либо задержка в передаче пакетов. Он контролирует это, устанавливая тайм-аут и сигналы, называемые подтверждениями.

## Вывод

Данные перемещаются в пакетах по цифровым сетям и все данные, которые мы потребляем, будь то текст, аудио, изображения или видео, делятся на пакеты, которые снова собираются на наших устройствах или компьютерах. Вот почему, например, когда изображение загружается по медленному соединению, вы видите, что куски его появляются один за другим.

#### Дополнительная информация:

[Все концепции сети в кратких подробностях](https://www.lifewire.com/what-is-a-data-packet-3426310 "Статья Lifewire о пакетах данных")