---
title: Nodejs- Buffer
localeTitle: Nodejs-Buffer
---
## Buffer (Буфер)

Бинарный или двоичный формат - это просто набор нулей и единиц. Каждое число в двоичном формате называется _бит_ . Компьютер преобразует данные в двоичный формат для хранения и выполнения операций. Например, вот пять различных данных в двоичном формате:

`10, 01, 001, 1110, 00101011`

JavaScript не имеет типа для представления данных в двоичном формате в своем API. Для работы с такими данными в Node.js есть глобальный модуль `Buffer` .

### Создание буфера

Существуют различные способы создания буфера в Node.js. Можно создать пустой буфер размером 10 байт.

```javascript
const buf1 = Buffer.alloc(10); 
```

Содание буфера из строки с кодировкой UTF-8 происходит так:

```javascript
const buf2 = Buffer.from('Hello World!'); 
```

Есть несколько вариантов кодировки при создании буфера:

*   ASCII
*   UTF-8
*   base64:
*   latin1
*   binary
*   hex

В Buffer API есть три отдельные функции для работы и создания новых буферов. В приведенных выше примерах мы видели `alloc()` и `from()` . Третий вариант - `allocUnsafe()` .

```javascript
const buf3 = Buffer.allocUnsafe(10); 
```

Эта функция не обязательно возвращает буфер заполненный нулями, в отличие от `.allocSafe()`, .

### Работа с буфером

Существуют различные функции в Buffer API, с помощью которых мы можем работать. Здесь мы рассмотрим большинство из них. Начнем с преобразования буфера в JSON.

```javascript
let bufferOne = Buffer.from('This is a buffer example.'); 
 console.log(bufferOne); 
 
 // Output: <Buffer 54 68 69 73 20 69 73 20 61 20 62 75 66 66 65 72 20 65 78 61 6d 70 6c 65 2e> 
 
 let json = JSON.stringify(bufferOne); 
 console.log(json); 
 
 // Output: {"type": "Buffer", "data": [84,104,105,115,32,105,115,32,97,32,98,117,102,102,101,114,32,101,120,97,109,112,108,101,46]} 
```

JSON указывает, что тип преобразуемого объекта - буфер и содержит его данные. Преобразование пустого буфера в JSON укажет нам, что он содержит только нули.

```javascript
const emptyBuf = Buffer.alloc(10); 
 
 emptyBuf.toJSON(); 
 
 // Output: { "type": "Buffer", "data": [ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 ] } 
```

`toJSON()` внимание, что само Buffer API также содержит функцию `toJSON()` для преобразования буфера в объект JSON. Чтобы узнать размер буфера, мы можем использовать метод `length` .

```javascript
emptyBuf.length; 
 // Output: 10 
```

Теперь давайте преобразуем буфер в читаемую строку, в нашем случае, в строку с кодировкой utf-8.

```javascript
console.log(bufferOne.toString('utf8')); 
 
 // Output: This is a buffer example. 
```

`.toString()` по умолчанию преобразует буфер в строку формата utf-8. Если вы укажете нужную вам кодировку, можно преобразовать буфер в неё

```javascript
console.log(bufferOne.toString('base64')); 

```
