---
title: File System
localeTitle: Файловая система
---
## Файловая система

Модуль Node.js File System позволяет работать с файловой системой на вашем компьютере.

Node.js имеет набор встроенных модулей, которые вы можете использовать без дальнейшей установки. Аналогично, **модуль Файловой системы** содержит набор функций, которые необходимы для выполнения различных операций с такими файлами, как чтение и запись.

Чтобы включить модуль, используйте функцию `require()` с именем модуля.

```javascript
const fs = require('fs');
```

Общее использование модуля файловой системы:

*   Чтение файлов
*   Создание файлов
*   Обновить файлы
*   Удалить файлы
*   Переименование файлов

## Чтение файла

Метод `fs.readFile()` используется для чтения файла на вашем компьютере. Требуется три аргумента: имя файла, кодировка и функция обратного вызова.

Код Node.js для чтения файла с вашего компьютера и возврата содержимого на консоль.

```javascript
const fs = require('fs');
 fs.readFile('input.txt', 'utf-8', (err, data) => {
  if(err){
  console.log(err);
  }
  else{
  console.log("Content present in input.txt file : " + data.toString());
  }
 });
```

Вышеприведенный код считывает файл _input.txt_ с вашего компьютера и возвращает содержимое консоли.

### Шаги для выполнения:

*   У вас должен быть установлен Node.js на вашем компьютере.
*   Создайте файл _app.js_ и вставьте вышеуказанный код.
*   Создайте файл _input.txt_ и напишите в него некоторый контент.
*   Теперь откройте консоль в рабочем каталоге и выполните командный `node app.js`

_Примечание_ . Файл input.txt должен присутствовать в том же каталоге, где присутствует файл кода Node.js, иначе он выдает ошибку.

## Запись в файл

Метод `fs.writeFile()` принимает три аргумента: имя файла, содержимое и функцию обратного вызова.

Код Node.js для записи содержимого в файл.

```javascript
const fs = require('fs');
 fs.writeFile('output.txt', "New content added", (err, data) => {
    if(err){
        console.log(err);
    }
    else{
        console.log("The file is saved");
    }
 });
```

Вышеприведенный код создает файл _output.txt_ и добавляет контент. Добавлен _новый контент_ .

### Шаги для выполнения:

*   У вас должен быть установлен Node.js на вашем компьютере.
*   Создайте файл _app.js_ и вставьте вышеуказанный код.
*   Теперь откройте консоль в рабочем каталоге и выполните командный `node app.js`

_Примечание_ . Если файл не существует, метод `fs.writeFile()` создает файл и записывает в него содержимое. Напротив, если файл существует, он перезаписывает содержимое в файле.

## Ресурсы

*   [API Node.js](https://nodejs.org/api/fs.html#fs_file_system)
*   [W3 Школы](https://www.w3schools.com/nodejs/nodejs_filesystem.asp)