---
title: NPM
localeTitle: NPM
---
## NPM

Node.js позволяет писать приложения в JavaScript на сервере. Он построен на среде исполнения V8 JavaScript и написан на C ++ - так что это быстро. Первоначально он был предназначен как серверная среда для приложений, но разработчики начали использовать его для создания модулей, чтобы помочь им в локальной автоматизации задач. С тех пор вся новая экосистема инструментов, основанных на узлах, эволюционировала, чтобы трансформировать лицо переднего плана.

Чтобы использовать эти модули (или пакеты) в Node.js, мы должны иметь возможность устанавливать и управлять ими полезным способом. Здесь приходит npm, менеджер пакетов Node. Он устанавливает пакеты, которые вы хотите использовать, и предоставляет полезный интерфейс для работы с ними.

## Установка NPM

Чтобы установить `npm` мы должны загружать двоичные файлы Nodejs в вашем локальном envrionment. В двоичные файлы Node.js включена последняя версия npm. Чтобы убедиться, что:

```shell
npm -v 
 5.6.0 
```

Node Package Manager (NPM) предоставляет две основные функции:

*   Интернет-хранилища для пакетов / модулей node.js, которые можно найти на `npmjs.com` .
    
*   Утилита командной строки для установки пакетов Node.js, управления версиями и управления зависимостями пакетов Node.js.
    

## Установка модулей с использованием NPM

`npm` может устанавливать пакеты в локальном или глобальном режиме. По умолчанию NPM устанавливает любую зависимость в локальном режиме. В локальном режиме он устанавливает пакет в папку node\_modules в родительском рабочем каталоге. Это место принадлежит текущему пользователю. Глобальные пакеты устанавливаются в {prefix} `/lib/node_modules/` который принадлежит root, где {prefix} обычно `/usr/ or /usr/local` . Это означает, что вам придется использовать sudo для установки пакетов по всему миру, что может привести к ошибкам при разрешении сторонних зависимостей, а также к проблемам безопасности.

### Установка пакетов в глобальном режиме

Любые пакеты, установленные во всем мире, станут доступны из командной строки. Мы используем флаг -global или -g для установки пакетов по всему миру.

```shell
$ npm install uglify-js --global 
```

Мы можем перечислить глобальные пакеты, которые мы установили, с командой списка npm.

```shell
$ npm list --global 
 /usr/local/lib 
 ├─┬ npm@5.6.0 
 │ ├── abbrev@1.1.0 
 │ ├── ansi-regex@2.1.1 
 │ ├── ansicolors@0.3.2 
 │ ├── ansistyles@0.1.3 
 .................... 
 └─┬ uglify-js@3.0.15 
  ├─┬ commander@2.9.0 
  │ └── graceful-readlink@1.0.1 
  └── source-map@0.5.6 
```

Однако вывод является довольно подробным. Мы можем изменить это с помощью опции --depth = 0.

```js
$ npm list -g --depth=0 
 /usr/local/lib 
 ├── npm@5.6.0 
 └── uglify-js@3.0.15 
```

### Установка пакетов в локальном режиме

Когда вы устанавливаете пакеты локально, вы обычно делаете это с помощью файла package.json.

```shell
npm install --save express 
```

Теперь вы можете использовать этот модуль в своем js-файле, как показано ниже.

```js
const express = require('express'); 
```

Локальные модули далее делятся на два типа зависимостей: `devDepenednecies` и `dependencies` . Разница между этими двумя заключается в том, что devDependencies - это модули, которые необходимы только во время разработки, а зависимости - это модули, которые также требуются во время выполнения. Чтобы сохранить зависимость как devDependency при установке, нам нужно сделать `npm install --save-dev` , а не только `npm install --save` .

Хорошая стенограмма для установки devDependency, которую я люблю использовать, - `npm i -D` . Сокращение для сохранения регулярной зависимости - это `-S` вместо `-D` .

### Установка конкретной версии пакета

Для этого укажем версию пакета, которую мы хотим установить.

```shell
$ npm install underscore@1.8.2 -S 
```

Чтобы удалить глобальную зависимость, используйте флаг `-g` .

### Удаление локальных пакетов

npm - менеджер пакетов, поэтому он должен иметь возможность удалить пакет. Мы можем удалить пакет:

```shell
$ npm uninstall underscore -S 
```

Чтобы обновить глобальную зависимость, используйте флаг `-g` .

### Обновление пакета

Чтобы обновить пакет, вы можете:
```
$ npm update underscore -S 
```

Чтобы проверить, доступно ли обновление для любого пакета, связанного с нашим проектом:

```shell
$ npm outdated 
 
 Package     Current  Wanted  Latest  Location 
 underscore    1.8.2   1.8.3   1.8.3  project 
```

Текущий столбец показывает нам версию, установленную локально. Последняя колонка сообщает нам последнюю версию пакета. И столбец Wanted сообщает нам последнюю версию пакета, которую мы можем обновить, не нарушая существующий код.

## Управление зависимостями с помощью package.json

Если не использовать определенный флаг и установить модуль, например, `npm install express` будет устанавливать модуль в папке `node_modules` локально, но `package.json` который ведет записи обо всех зависимостях, которые мы используем в проекте, не будет обновляться с нашим добавлением. Таким образом, пакет будет специфичным для разработки, он не будет установлен в среде runtimme. Убедитесь, что вы всегда используете правильный флаг и сохраняете файл `package.json` .

Когда вы устанавливаете пакеты локально, вам нужен файл package.json. Для его создания вы можете сделать это, используя команду `npm init` . Это вызовет некоторые вопросы, которые, нажав enter, вы можете сохранить значения по умолчанию.

```shell
$ npm init 
 package name: (project) 
 version: (1.0.0) 
 description: Demo of package.json 
 entry point: (index.js) 
 test command: 
 git repository: 
 keywords: 
 author: 
 license: (ISC) 
```

Подумайте, что `package.json` является хранителем всех зависимостей или проявлением проекта Node.js. Если вам нужен более быстрый способ сгенерировать файл package.json, используйте `npm init --y` .

Список общих атрибутов в файле `package.json` :

*   name - имя пакета
    
*   версия - семантическая версия пакета
    
*   описание - описание пакета
    
*   домашняя страница - домашняя страница пакета
    
*   автор - автор пакета
    
*   вкладчики - имя вкладчиков в пакет
    
*   dependencies - список зависимостей. NPM автоматически устанавливает все зависимости, указанные здесь, в папке node\_module пакета.
    
*   devDependencies - список всех зависимостей, зависящих от разработки
    
*   репозиторий - тип репозитория и URL-адрес пакета
    
*   главная - точка входа пакета
    
*   ключевые слова - ключевые слова
    
*   лицензия - лицензия на ваш пакет, чтобы люди знали, как им разрешено использовать его, и любые ограничения, которые вы устанавливаете на него.
    
*   scripts - Свойство «scripts» - это словарь, содержащий команды скриптов, которые выполняются в разное время на жизненном цикле вашего пакета.
    
*   config - объект, который можно использовать для установки параметров конфигурации, используемых в сценариях пакета, которые сохраняются при обновлении.
    

Пример:

```json
{ 
   "name": "express", 
      "description": "Fast, unopinionated, minimalist web framework", 
      "version": "4.11.2", 
      "author": { 
 
         "name": "TJ Holowaychuk", 
         "email": "tj@vision-media.ca" 
      }, 
 
   "contributors": [{ 
      "name": "Aaron Heckmann", 
      "email": "aaron.heckmann+github@gmail.com" 
   }, 
 
    ], 
   "license": "MIT", "repository": { 
      "type": "git", 
      "url": "https://github.com/strongloop/express" 
   }, 
   "homepage": "https://expressjs.com/", "keywords": [ 
      "express", 
      "framework", 
      "sinatra", 
      "web", 
      "rest", 
      "restful", 
      "router", 
      "app", 
      "api" 
   ], 
   "dependencies": { 
      "serve-static": "~1.8.1", 
 
   }, 
   "devDependencies": { 
      "jade": "~1.9.1", 
   }, 
   "engines": { 
      "node": ">= 0.10.0" 
   }, 
   "files": [ 
      "LICENSE", 
      "History.md", 
      "Readme.md", 
      "index.js", 
      "lib/" 
   ], 
   "scripts": { 
      "test": "mocha --require test/support/env 
         --reporter spec --bail --check-leaks test/ test/acceptance/", 
      "test-cov": "istanbul cover node_modules/mocha/bin/_mocha 
         -- --require test/support/env --reporter dot --check-leaks test/ test/acceptance/", 
      "test-tap": "mocha --require test/support/env 
         --reporter tap --check-leaks test/ test/acceptance/", 
      "test-travis": "istanbul cover node_modules/mocha/bin/_mocha 
         --report lcovonly -- --require test/support/env 
         --reporter spec --check-leaks test/ test/acceptance/" 
   }, 
 
 } 
```

## Скрипты npm

Скрипты `npm` используются для автоматизации повторяющихся задач. Например, создание вашего проекта, минимизация каскадных таблиц стилей (CSS) и JavaScript (JS). Сценарии также используются при удалении временных файлов и папок и т. Д. Они могут быть настроены и доступны через объект `scripts` в `package.json` .

```json
{ 
  "name": "super-cool-package", 
  "version": "1.0.0", 
  "scripts": {} 
 } 
```

Пример наиболее популярного сценария NPM:

```json
"scripts": { 
    "start": "node index.js", 
    ... 
 } 
```

## npm Кэш

Когда npm устанавливает пакет, он сохраняет копию, поэтому в следующий раз, когда вы захотите установить этот пакет, ему не нужно попадать в сеть. Копии хранятся в каталоге .npm в домашнем каталоге.

```shell
$ ls ~/.npm 
 lodash.zipobject 
 log-driver 
 log-symbols 
 logalot 
 logfmt 
 loglevel 
 long-timeout 
 longest 
 longest-strea 
```

С тех пор этот каталог будет загроможден старыми пакетами, поэтому иногда полезно его очищать.

```shell
$ npm cache clean 
```

## Пряжа - альтернатива гамме

Пряжа - также менеджер пакетов JavaScript, разработанный и поддерживаемый Facebook. Оба имеют общий уровень сходства, когда они приходят к их использованию. Предполагается, что он будет быстрее устанавливать зависимости, чем npm. Чтобы установить его:

```shell
npm install -g yarn 
```

Пряжа не намеревается заменить npm, больше похоже на улучшение на нем. Он использует один и тот же файл package.json и сохраняет зависимости от папки `node_modules/` . Чтобы инициализировать projcet, вы будете использовать:

```shell
yarn init 
```

### Добавление, обновление и устранение зависимостей

Добавление новой зависимости легко и похоже на npm:

```shell
yarn add [package-name] 
```

Если вам нужна конкретная версия пакета или тег, вы можете это сделать.

```shell
yarn add express@4.14.1 
```

Для зависимостей dev, одноранговых зависимостей и необязательных зависимостей вы передаете -dev -peer -optional соответственно.

```shell
yarn add gulp --dev 
```

Будет экономить gulp под devDependencies. Чтобы обновить или удалить пакет, вы просто заменяете команду add либо обновлением, либо удалением, за которым следует имя пакета.

```shell
# upgrade a gulp from 3.9.1 to version 4 
 yarn upgrade gulp@4.0 
 
 # remove a gulp 
 yarn remove gulp 
```

После каждой установки, обновления или удаления пряжа обновляет файл yarn.lock, который отслеживает точную версию пакета, установленную в каталоге node\_modules. Аналогичная функция была обновлена ​​в npm. Теперь есть `package-lock.json` которые ведут себя точно так же, как и `yarn.lock` в новых версиях npm.

### Номера версий пакета и то, что они означают

Первый выпуск пакета npm всегда равен 1.0.0

Исправлены ошибки, или незначительные изменения увеличивали третью цифру, а hense 1.0.0 стал 1.0.1

Новые функции, которые не прерывают предыдущие версии пакета, увеличивают вторую цифру, hense 1.0.0 станет 1.1.0

Все изменения, которые нарушают предыдущие выпуски пакета, увеличивают первую цифру, hense 1.0.0 станет 2.0.0

Важно помнить об этом при обновлении пакетов, чтобы сохранить стабильный проект!