---
title: Process Object
localeTitle: Объект process
---
## Объект process

Объект `process` в Node.js является глобальным объектом, доступ к которому возможен из любого модулу, не запрашивая его с помощью `require`. В Node.js очень мало глобальных объектов или свойств, и `process` является одним из них. Это важный компонент в экосистеме Node.js, поскольку он предоставляет различные наборы информации о среде выполнения программы. Для изучения мы будем использовать одно из его свойств, который называется `process.versions` . Это свойство содержит информацию о версии Node.js, которую мы установили. Вызовем его из node.js с помощью флага `-p` .

```shell
$ node  -p "process.versions" 
 
 # output 
 { http_parser: '2.8.0', 
  node: '8.11.2', 
  v8: '6.2.414.54', 
  uv: '1.19.1', 
  zlib: '1.2.11', 
  ares: '1.10.1-DEV', 
  modules: '57', 
  nghttp2: '1.29.0', 
  napi: '3', 
  openssl: '1.0.2o', 
  icu: '60.1', 
  unicode: '10.0', 
  cldr: '32.0', 
  tz: '2017c' } 
```

Еще одно свойство, которое можно проверить - это `process.release` . То же самое, что и команда `$ node --version` которую мы использовали, когда устанавливали Node.js, но на этот раз вывод будет более подробным.

```shell
node -p "process.release" 
 
 # output 
 { name: 'node', 
  lts: 'Carbon', 
  sourceUrl: 'https://nodejs.org/download/release/v8.11.2/node-v8.11.2.tar.gz', 
  headersUrl: 'https://nodejs.org/download/release/v8.11.2/node-v8.11.2-headers.tar.gz' } 
```

Это несколько команд, которые мы можем использовать в командной строке для доступа к той информации, которую модуль не может предоставить. Объект `process` является экземпляром класса EventEmitter, и он содержит свои собственные заранее определенные события, такие как `exit`, которое может быть использовано, чтобы узнать, когда программа завершила выполнение. Запустив программу ниже, можно заметить, что он выполнилась с кодом состояния `0` . В Node.js этот код означает, что программа выполнелась успешно.

```js
process.on('exit', code => { 
    setTimeout(() => { 
        console.log('Will not get displayed'); 
    }, 0); 
 
    console.log('Exited with status code:', code); 
 }); 
 console.log('Execution Completed'); 
```

Вывод упомянутой программы:

```shell
Execution Completed 
 Exited with status code: 0 
```

`Process` также предоставляет различные свойства для взаимодействия. Некоторые из них могут использоваться в приложении Node для предоставления шлюза для связи между приложением Node и любым интерфейсом командной строки. Это очень полезно, если вы создаете приложение командной строки или утилиту с помощью Node.js

*   process.stdin: поток для чтения
*   process.stdout: поток для вывода
*   process.stderr: поток для вывода ошибок

Используя `argv` вы всегда можете получить доступ к аргументам, которые передаются в командной строке. `argv` - это массив, в котором первый элемент - абсолютный путь к исполняемому файлу Node.js, второй - абсолютный путь к файлу вашего приложения. Начиная с третьего элемента и дальше он содержит аргументы командной строки.

Запустите программу ниже, чтобы получить больше информации о том, как вы можете использовать эти различные свойства и функции.

```js
process.stdout.write('Hello World!' + '\n'); 
 
 process.argv.forEach(function(val, index, array) { 
    console.log(index + ': ' + val); 
 }); 
```

Если вы запустите указанный выше код с помощью вот такой команды команды, вы получите на выходе первые два элемента из `argv`.

```shell
$ node test.js 
 
 # output 
 Hello World! 
 0: /usr/local/bin/node 
 1: /Users/amanhimself/Desktop/articles/nodejs-text-tuts/test.js 

```
