---
title: PHP Syntax Overview
localeTitle: Обзор синтаксиса PHP
---
В этой главе вы получите представление о самом базовом синтаксисе PHP и очень важно сделать свой фундамент PHP сильным.

### Переход к PHP

Механизм разбора PHP нуждается в способе дифференцировать PHP-код от других элементов на странице. Механизм для этого известен как «переход к PHP». Есть четыре способа сделать это -

#### Канонические теги PHP

Наиболее универсально эффективный стиль PHP-тегов -
```
<?php...?> 
```

Если вы используете этот стиль, вы можете быть уверены, что ваши теги всегда будут правильно интерпретироваться.

#### Кратко открытые (SGML-стиль) теги

Короткие или коротко открытые теги выглядят так:
```
<?...?> 
```

Короткие теги, как и следовало ожидать, кратчайший. Вы должны сделать одну из двух вещей, чтобы PHP мог распознавать теги -

Выберите вариант --enable-short-tags, когда вы строите PHP.

Установите параметр короткого _открытого_ тега в файле php.ini для включения. Этот параметр должен быть отключен для синтаксического анализа XML с помощью PHP, поскольку для тегов XML используется тот же синтаксис.

#### Теги в стиле ASP

Теги в стиле ASP имитируют теги, используемые Active Server Pages для определения кодовых блоков. Теги в стиле ASP выглядят следующим образом:
```
<%...%> 
```

Чтобы использовать теги в стиле ASP, вам необходимо установить параметр конфигурации в файле php.ini.

#### Теги HTML-скрипта

Теги HTML-скриптов выглядят так:
```
<script language="PHP">...</script> 
```

### Комментирование PHP-кода

Комментарий - это часть программы, которая существует только для читателя и убирается до отображения результатов программы. В PHP есть два формата комментариев:

#### Однострочные комментарии -

Они обычно используются для кратких пояснений или заметок, относящихся к местному коду. Ниже приведены примеры однострочных комментариев.

\`\` \` <? # Это комментарий, и # Это вторая строка комментария

// Это тоже комментарий. Только для комментариев по стилю print «Пример с комментариями по одной строке»; ?>
```
#### Multi-lines printing − 
 Here are the examples to print multiple lines in a single print statement − 
 
 ``` 
 <? 
   # First Example 
   print <<<END 
   This uses the "here document" syntax to output 
   multiple lines with $variable interpolation. Note 
   that the here document terminator must appear on a 
   line with just a semicolon no extra whitespace! 
   END; 
 
   # Second Example 
   print "This spans 
   multiple lines. The newlines will be 
   output as well"; 
 ?> 
```

#### Многострочные комментарии -

Обычно они используются для обеспечения алгоритмов псевдокода и более подробных объяснений, когда это необходимо. Многострочный стиль комментариев такой же, как и в C. Вот пример комментариев нескольких строк.
```
<? 
   /* This is a comment with multiline 
      Author : Mohammad Mohtashim 
      Purpose: Multiline Comments Demo 
      Subject: PHP 
   */ 
 
   print "An example with multi line comments"; 
 ?> 
```

### PHP без пробелов

Пробел - это материал, который вы вводите, который обычно невидим на экране, включая пробелы, вкладки и возврат каретки (символы конца строки).

PHP без пробелов означает, что он почти никогда не имеет значения, сколько пробельных символов у вас есть в строке. Один символ пробела совпадает со многими такими символами.

Например, каждый из следующих операторов PHP, который присваивает сумму 2 + 2 переменной $ Four, эквивалентен -
```
$four = 2 + 2; // single spaces 
 $four <tab>=<tab2<tab>+<tab>2 ; // spaces and tabs 
 $four = 
 2+ 
 2; // multiple lines 
```

### PHP чувствителен к регистру

Да, это правда, что PHP - это язык, чувствительный к регистру. Попробуйте следующий пример -
```
<html> 
   <body> 
 
      <?php 
         $capital = 67; 
         print("Variable capital is $capital<br>"); 
         print("Variable CaPiTaL is $CaPiTaL<br>"); 
      ?> 
 
   </body> 
 </html> 
```

Это приведет к следующему результату -
```
Variable capital is 67 
 Variable CaPiTaL is 
```

### Выражения - это выражения, заканчивающиеся точкой с запятой

Заявление в PHP - это любое выражение, за которым следует точка с запятой (;). Любая последовательность допустимых инструкций PHP, заключенная в теги PHP, является допустимой программой PHP. Вот типичный оператор в PHP, который в этом случае присваивает строку символов переменной $ greeting -
```
$greeting = "Welcome to PHP!"; 
```

### Выражения представляют собой комбинации токенов

Самые маленькие блоки PHP - это неделимые токены, такие как числа (3.14159), строки (.two), переменные ($ two), константы (TRUE) и специальные слова, которые составляют синтаксис самого PHP, как если бы , иначе, в то время как, для и так далее

### Скобки делают блоки

Хотя утверждения не могут быть объединены в виде выражений, вы всегда можете поместить последовательность инструкций в любом месте, где оператор может пойти, заключая их в набор фигурных скобок.

Здесь оба утверждения эквивалентны -
```
if (3 == 2 + 1) 
   print("Good - I haven't totally lost my mind.<br>"); 
 
 if (3 == 2 + 1) { 
   print("Good - I haven't totally"); 
   print("lost my mind.<br>"); 
 } 
```

### Запуск PHP-скрипта из командной строки

Да, вы можете запустить свой PHP-скрипт в командной строке. Предполагая, что у вас есть следующий контент в файле test.php
```
<?php 
   echo "Hello PHP!!!!!"; 
 ?> 
```

Теперь запустите этот скрипт как командную строку следующим образом:
```
$ php test.php 
```

Это приведет к следующему результату -
```
Hello PHP!!!!! 
```

Надеюсь, теперь у вас есть базовые знания PHP-синтаксиса.