---
title: Data Types
localeTitle: Типы данных
---
## Типы данных

	PHP поддерживает десять простых типов.
    
#### Четыре скалярных типа:
		* Булев
			Это простейший тип. `boolean` выражает истинность значения. Он может быть либо TRUE, либо FALSE.
			Для указания boolean, используйте константы TRUE или FALSE. Обе они регистронезависимы.
			
			<?php
				$foo = True; // присваивание $foo значение TRUE
			?>
			
		* Integer
			Это число из множества ℤ = {..., -2, -1, 0, 1, 2, ...}.
			
			<?php
				$a = 1234; // десятичное число
				$a = -123; // отрицательное число
				$a = 0123; // восьмеричное число (эквивалентно 83 в десятичной системе)
				$a = 0x1A; // шестнадцатеричное число (эквивалентно 26 в десятичной системе)
				$a = 0b11111111; // двоичное число (эквивалентно 255 в десятичной системе)
			?>
			
		* Float (Числа с плавающей точкой)
			Числа с плавающей точкой (также известные как "float", "double" или "real").
			
			<?php
				$a = 1.234; 
				$b = 1.2e3; 
				$c = 7E-10;
			?>
			
		* String (Строка)
			Это набор символов, где символ - это то же самое, что и байт.
			PHP поддерживает ровно 256 различных символов.
			PHP не имеет встроенной поддержки Unicode.
			
#### Четыре смешанных типа:
		
		* Массив
			Это упорядоченное отображение, которое устанавливает соответствие между значением и ключом.
			
		* Объект
			Для создания нового объекта, используйте выражение new, создающее в переменной экземпляр класса:
			
			<?php
				class foo
				{
					function do_foo()
				{
					echo "Код foo."; 
				}
				}

				$bar = new foo;
				$bar->do_foo();
			?>
			
			Преобразование в объект.
			Если object преобразуется в object, объект не изменится. Если значение другого типа преобразуется в object, создается новый экземпляр встроенного класса stdClass. Если значение было NULL, новый экземпляр будет пустым. Массивы преобразуются в object с именами полей, названными согласно ключам массива и соответствующими им значениям. Обратите внимание, что в этом случае до PHP 7.2.0 числовые ключи не будут доступны, пока не проитерировать объект.
			
			<?php
				$obj = (object) array('1' => 'foo');
				var_dump(isset($obj->{'1'})); // выводит 'bool(false)'
				var_dump(key($obj)); // выводит 'int(1)'

				$obj = (object) array('1' => 'foo');
				var_dump(isset($obj->{'1'})); // выводит 'bool(true)', начиная с PHP 7.2.0; 'bool(false)' ранее
				var_dump(key($obj)); // выводит 'string(1) "1"', начиная с PHP 7.2.0; 'int(1)' ранее
			?>
			
			При преобразовании любого другого значения, оно будет помещено в поле с именем scalar соответствующему типу.
			
			<?php
				$obj = (object) 'привет';
				echo $obj->scalar;  // выведет 'привет'
			?>
			
		* Функции обратного вызова (callback-функции)
			Callback-функции могут быть отмечены в коде подсказкой типа callable, появившейся в версии PHP 5.4. В данной документации для этих же целей используется callback.

			Некоторые функции, такие как call_user_func() или usort(), принимают определенные пользователем callback-функции в качестве параметра. Callback-функции могут быть как простыми функциями, так и методами объектов, включая статические методы классов.
			
			В PHP функции передаются по имени в виде строки. Можно использовать любые встроенные, либо созданные пользователем функции, за исключением конструкций языка, таких как: array(), echo, empty(), eval(), exit(), isset(), list(), print или unset().

			Метод созданного объекта (object) передается как массив, содержащий объект по индексу 0 и имя метода по индексу 1. Доступ к закрытым и защищенным методам разрешен изнутри класса.

			Статические методы класса также могут быть вызваны без создания экземпляра объекта класса путем передачи имени класса вместо объекта в элементе массива с индексом 0. С PHP 5.2.3 также можно передавать 'ClassName::methodName'.

			Помимо обычных пользовательских функций, в качестве callback-функции можно передавать анонимные функции.
			
			<?php

				// Пример callback-функции
				function my_callback_function() {
				echo 'Привет, мир!';
			}
			
			?>
			
#### Два специальных типа:
	
		* Ресурс
			Ресурс - это специальная переменная, содержащая ссылку на внешний ресурс. Ресурсы создаются и используются специальными функциями. Полный перечень этих функций и соответствующих типов ресурсов (resource) смотрите в приложении.
			
			Поскольку тип resource содержит специальные указатели на открытые файлы, соединения с базой данных, области изображения и тому подобное, преобразование в этот тип не имеет смысла.
			
			Благодаря системе подсчета ссылок, введенной в Zend Engine, определение отсутствия ссылок на ресурс происходит автоматически, после чего он освобождается сборщиком мусора. Поэтому очень редко требуется освобождать память вручную.
			
		* NULL
			Специальное значение NULL представляет собой переменную без значения. NULL - это единственно возможное значение типа null.
			
			Переменная считается null, если:
			- ей была присвоена константа NULL.
			- ей еще не было присвоено никакого значения.
			- она была удалена с помощью unset().
			
			Существует только одно значение типа null - регистронезависимая константа NULL.
			
			<?php
				$var = NULL;       
			?>
			
			**Данный функционал объявлен УСТАРЕВШИМ, начиная с PHP 7.2.0 и его использование крайне не рекомендовано.
			
			Приведение переменной к null с использованием (unset) $var не удаляет переменную и ее значение. Данное выражение только возвращает NULL.
				
#### Итоговые примеры:

		<?php
			$a_bool = TRUE;   // логический
			$a_str  = "foo";  // строковый
			$a_str2 = 'foo';  // строковый
			$an_int = 12;     // целочисленный

			echo gettype($a_bool); // выводит: boolean
			echo gettype($a_str);  // выводит: string

			// Если это целое, увеличить на четыре
			if (is_int($an_int)) {
   			$an_int += 4;
			}

			// Если $a_bool - это строка, вывести ее
			// (ничего не выводит)
			if (is_string($a_bool)) {
   			echo "Строка: $a_bool";
			}
		?>
			




#### Дополнительная информация:
[Типы данных PHP](http://php.net/manual/ru/language.types.intro.php)
