---
title: Errors
localeTitle: ошибки
---
## Ошибки при выполнении кода PHP

  PHP сообщает об ошибках в ответ на некоторые внутренние ошибочные обстоятельства.
  Они могут быть использованы для уведомления о разных состояниях, а также могут выводиться на экран и записываться в логи по желанию.
  Каждая ошибка, генерируемая PHP, обязательно содержит информацию о своем типе.
  
    Примеры:
    E_ERROR               => 'Ошибка';
    E_WARNING             => 'Предупреждение';
    E_PARSE               => 'Ошибка разбора исходного кода';
    E_NOTICE              => 'Уведомление';
    E_CORE_ERROR          => 'Ошибка ядра';
    E_CORE_WARNING        => 'Предупреждение ядра';
    E_COMPILE_ERROR       => 'Ошибка на этапе компиляции';
    E_COMPILE_WARNING     => 'Предупреждение на этапе компиляции';
    E_USER_ERROR          => 'Пользовательская ошибка';
    E_USER_WARNING        => 'Пользовательское предупреждение';
    E_USER_NOTICE         => 'Пользовательское уведомление';
    E_STRICT              => 'Уведомление времени выполнения';
    E_RECOVERABLE_ERROR   => 'Отлавливаемая фатальная ошибка'.
    
### Функции обработки ошибок

    debug_backtrace()
    выводит стек вызовов функций PHP в массив.
    
    debug_print_backtrace()
    выводит стек вызовов функций. Выводит вызовы функций, имена включенных/требуемых файлов и другую информацию из функций (eval()).
    
    error_clear_last()
    очистить самую последнюю ошибку.
    
    error_get_last()
    получение информации о последней произошедшей ошибке.
    
    error_log()
    отправляет сообщение об ошибке заданному обработчику ошибок.
    
    error_reporting()
    задает, какие ошибки PHP попадут в отчет.
    
    restore_error_handler()
    восстанавливает предыдущий обработчик ошибок.
    
    restore_exception_handler()
    восстанавливает предыдущий обработчик исключений.
    
    set_error_handler()
    задает пользовательский обработчик ошибок.
    
    set_exception_handler()
    задает пользовательский обработчик исключений.
    
    trigger_error()
    вызывает пользовательскую ошибку/предупреждение/уведомление.
    
    user_error()
    то же самое, что и trigger_error().
    
  






#### Дополнительная информация:
  *  [Обработка и логирование ошибок PHP](http://php.net/manual/ru/book.errorfunc.php)
