---
title: PHP
localeTitle: PHP
---
![logo](https://upload.wikimedia.org/wikipedia/commons/thumb/2/27/PHP-logo.svg/150px-PHP-logo.svg.png "Логотип PHP")

## Что такое PHP?

PHP - это серверный скриптовый язык, созданный в 1995 году Расмусом Лердорфом.

PHP - широко используемый язык сценариев общего назначения с открытым исходным кодом, который особенно подходит для веб-разработки и может быть встроен в HTML.

## Что означает акроним PHP?

Первоначально PHP стоял за «Личную домашнюю страницу», поскольку Расмус Лердорф создал его для использования на своем собственном веб-сайте. Затем в 1997 году разработчики расширили язык и аббревиатура также изменилась на то, что она обозначает сегодня: «PHP: Hypertext Preprocessor». Поскольку первый «P» в PHP также означает «PHP», он известен как «рекурсивный акроним».

## Для чего используется PHP?

По состоянию на октябрь 2017 года PHP используется на [82% сайтов, серверный язык которых известен](https://w3techs.com/technologies/overview/programming_language/all) . это обычно используется на веб-сайтах для динамического создания содержимого веб-страницы. Варианты использования включают:

*   Веб-сайты и веб-приложения (серверные скрипты)
*   Сценарии командной строки
*   Настольные (GUI) приложения

Как правило, он используется в первой форме для динамического создания содержимого веб-страницы. Например, если у вас есть сайт блога, вы можете написать некоторые PHP-скрипты для извлечения ваши сообщения в блоге из базы данных и их отображение. Другие варианты использования скриптов PHP включают:

*   Обработка и сохранение пользовательского ввода из данных формы
*   Настройка и работа с файлами веб-сайта
*   Ограничение доступа к определенным страницам вашего сайта

## Как работает PHP?

Весь PHP-код выполняется только на веб-сервере, а не на вашем локальном компьютере. Например, если вы заполняете форму на веб-сайте и отправляете ее, либо щелкните ссылку на веб-страницу, написанную на PHP, на вашем компьютере не будет установлен настоящий PHP-код. Вместо этого данные формы или запрос на веб-страницу отправляются на веб-сервер, который обрабатывается скриптами PHP. Затем веб-сервер отправляет обработанный HTML обратно (откуда и появляется «Hypertext Preprocessor» в названии), и ваш веб-браузер отображает результаты. По этой причине вы не можете видеть PHP-код веб-сайта, а только полученный HTML-код, созданный скриптами PHP.

Это показано ниже:

![PHP-сервер-модель](https://github.com/xeroxism/myImages/blob/master/FCC_guides/PHP-server-model.png?raw=true)

PHP - интерпретируемый язык. Это означает, что когда вы вносите изменения в исходный код, вы можете сразу протестировать эти изменения без предварительного компиляции исходного кода в двоичную форму. Пропуск этапа компиляции делает процесс разработки намного быстрее.

PHP-код заключен между тегами `<?php` и `?>` И затем может быть встроен в HTML.

## Монтаж

PHP может быть установлен с веб-сервером или без него.

### GNU / Linux

На дистрибутивах GNU / Linux на Debian вы можете установить:

```bash
sudo apt install php 
```

После установки вы можете запускать любые файлы PHP, просто сделав это в терминале:
```
php file.php 
```

Вы также можете установить сервер localhost для запуска веб-сайтов PHP. Для установки Apache Web Server:
```
sudo apt install apache2 libapache2-mod-php 
```

## Что может сделать PHP?

*   PHP может генерировать динамическое содержимое страницы
*   PHP может создавать, открывать, читать, писать, удалять и закрывать файлы на сервере
*   PHP может собирать данные формы
*   PHP может отправлять и получать файлы cookie
*   PHP может добавлять, удалять, изменять данные в вашей базе данных
*   PHP можно использовать для управления доступом пользователей
*   PHP может шифровать данные

## Почему PHP?

*   PHP работает на разных платформах (Windows, Linux, Unix, Mac OS X и т. Д.)
*   PHP совместим почти со всеми используемыми сегодня серверами (Apache, IIS и т. Д.).
*   PHP поддерживает широкий спектр баз данных
*   PHP бесплатный. Загрузите его с официального ресурса PHP: [secure.php.net](https://secure.php.net/)
*   PHP легко учится и работает эффективно на стороне сервера

## PHP Frameworks

Поскольку написание всего кода для веб-сайта не является практически практичным / практически возможным для большинства проектов, большинство разработчиков склонны использовать рамки для веб-разработки. Преимущество использования структуры заключается в том, что

*   Вам не нужно изобретать велосипед каждый раз, когда вы создаете проект, многие нюансы уже позаботились о вас
*   Они, как правило, хорошо структурированы, так что это помогает в разделении проблем
*   Большинство рамок, как правило, придерживаются лучших практик языка
*   Многие из них следуют шаблону MVC (Model-View-Controller), так что он отделяет уровень представления от логики

## Популярные рамки

*   [Laravel](https://laravel.com/)
*   [Symfony](https://symfony.com/)
*   [Zend](http://www.zend.com/)
*   [CakePHP](https://cakephp.org/)

## Документация

PHP [хорошо документирован](http://php.net/docs.php) . [Официальные документы](http://php.net/manual/en/) включают примеры почти в каждое справочное руководство по функциям, а также комментарии пользователей.

## Другие источники

*   [Tizag.com PHP Tutorial](http://www.tizag.com/phpT/) : все еще соответствующие учебники для начала работы с PHP
*   [Awesome PHP](https://github.com/ziadoz/awesome-php) : кураторский список библиотек PHP, ресурсов и «блестящих вещей»,
*   [Laracasts.com](https://laracasts.com/) : веб-сайт членства для изучения разработки веб-приложений с помощью PHP