---
title: For Loop
localeTitle: Для цикла
---
## Для цикла

Оператор PHP `for` состоит из трех выражений и оператора:

`for ((initialization); (condition); (final-expression)) statement`

### Описание

*   инициализация
    *   Запуск до первого выполнения цикла.
    *   Это выражение обычно используется для создания счетчиков.
    *   Переменные, созданные здесь, привязаны к циклу. Как только цикл закончен, это исполнение, они уничтожены.
*   состояние
    *   Выражение, которое проверяется перед выполнением каждой итерации.
    *   Если это опущено, это выражение оценивается как `true` .
*   Окончательное выражение
    *   Выражение, которое запускается после каждой итерации.
    *   Обычно используется для увеличения счетчика.
    *   Но он может использоваться для запуска любого выражения.
*   заявление
    *   Код должен повторяться в каждой итерации цикла.

Любое из этих трех выражений или утверждение может быть ограничено.

Выражения могут содержать несколько выражений, разделенных запятой.

В выражении (condition) будут вычислены все выражения, разделенные запятыми.

Результат получается из последнего.

Для циклов обычно используются для подсчета определенного количества итераций для повторения утверждения.

### Общие проблемы

#### Превышение границ массива

При многократном индексировании по массиву легко превзойти границы массива (например, попытайтесь ссылаться на 4-й элемент массива из 3 элементов).

```php
// This will cause an error. 
 // The bounds of the array will be exceeded. 
 $arr = array(1,2,3); 
 
 for ($i = 0; $i <= count($arr); $i++) { 
    var_dump($arr[$i]); 
 } 
```

Это приведет к выводу:

```txt
int(1) int(2) int(3) NULL 
```

Есть способы исправить этот код.

Задайте условие либо `$i < count($arr)` либо `$i <= count($arr) - 1` .

#### Проблемы с производительностью

Вышеприведенный код может стать медленным, так как размер массива выбирается на каждой итерации.

Чтобы исправить эту проблему, можно поместить размер массива в переменную.

```php
//create the $size variable with a second expression comma separated 
 for ($i = 0, $size = count($arr); $i < $size; ++$i) { 
```

### Больше информации

*   [PHP.net - Структуры управления](https://secure.php.net/manual/en/control-structures.for.php)