---
title: PHP 5 echo and print Statements
localeTitle: PHP 5 эхо и печати
---
В PHP есть два основных способа получения вывода: эхо и печать.

В этом уроке мы используем эхо (и печать) почти в каждом примере. Итак, в этой главе содержится немного больше информации об этих двух выводах.

### PHP-эхо-сигналы

эхо и печать более или менее одинаковы. Они используются для вывода данных на экран.

Различия малы: echo не имеет возвращаемого значения, а печать имеет возвращаемое значение 1, поэтому его можно использовать в выражениях. echo может принимать несколько параметров (хотя такое использование встречается редко), в то время как печать может принимать один аргумент. эхо немного быстрее, чем печать.

### Заявление эха PHP

Оператор echo может использоваться с круглыми скобками или без них: echo или echo ().

#### Показать текст

В следующем примере показано, как выводить текст с помощью команды echo (обратите внимание, что текст может содержать разметку HTML):

#### пример

```php
<?php 
 echo "<h2>PHP is Fun!</h2>"; 
 echo "Hello world!<br>"; 
 echo "I'm about to learn PHP!<br>"; 
 echo "This ", "string ", "was ", "made ", "with multiple parameters."; 
 ?> 
```

#### Отображать переменные

В следующем примере показано, как выводить текст и переменные с помощью инструкции echo:

#### пример

```php
<?php 
 $txt1 = "Learn PHP"; 
 $txt2 = "W3Schools.com"; 
 $x = 5; 
 $y = 4; 
 
 echo "<h2>" . $txt1 . "</h2>"; 
 echo "Study PHP at " . $txt2 . "<br>"; 
 echo $x + $y; 
 ?> 
```

### Заявление о печати PHP

Оператор print может использоваться с круглыми скобками или без них: print или print ().

#### Показать текст

В следующем примере показано, как выводить текст с помощью команды print (обратите внимание, что текст может содержать разметку HTML):

#### пример

```php
<?php 
 print "<h2>PHP is Fun!</h2>"; 
 print "Hello world!<br>"; 
 print "I'm about to learn PHP!"; 
 ?> 
```

#### Отображать переменные

В следующем примере показано, как выводить текст и переменные с помощью оператора печати:

#### пример

```php
<?php 
 $txt1 = "Learn PHP"; 
 $txt2 = "W3Schools.com"; 
 $x = 5; 
 $y = 4; 
 
 print "<h2>" . $txt1 . "</h2>"; 
 print "Study PHP at " . $txt2 . "<br>"; 
 print $x + $y; 
 ?> 

```