---
title: PHP 5 Form Handling
localeTitle: Обработка форм PHP 5
---
Суперграфы PHP $ _GET и $_ POST используются для сбора данных формы.

### PHP - простая форма HTML

В приведенном ниже примере представлена ​​простая форма HTML с двумя полями ввода и кнопкой отправки:

#### пример

```php
<html> 
 <body> 
 
 <form action="welcome.php" method="post"> 
 Name: <input type="text" name="name"><br> 
 E-mail: <input type="text" name="email"><br> 
 <input type="submit"> 
 </form> 
 
 </body> 
 </html> 
```

Когда пользователь заполняет форму выше и нажимает кнопку отправки, данные формы отправляются для обработки в файл PHP с именем «welcome.php». Данные формы отправляются методом HTTP POST.

Чтобы отобразить представленные данные, вы можете просто отбросить все переменные. «Welcome.php» выглядит так:

```php
<html> 
 <body> 
 
 Welcome <?php echo $_POST["name"]; ?><br> 
 Your email address is: <?php echo $_POST["email"]; ?> 
 
 </body> 
 </html> 
```

Результат может быть примерно таким:
```
Welcome John 
 Your email address is john.doe@example.com 
```

Тот же результат может быть достигнут с использованием метода HTTP GET:

#### пример

```php
<html> 
 <body> 
 
 <form action="welcome_get.php" method="get"> 
 Name: <input type="text" name="name"><br> 
 E-mail: <input type="text" name="email"><br> 
 <input type="submit"> 
 </form> 
 
 </body> 
 </html> 
```

и "welcome\_get.php" выглядит так:

```php
<html> 
 <body> 
 
 Welcome <?php echo $_GET["name"]; ?><br> 
 Your email address is: <?php echo $_GET["email"]; ?> 
 
 </body> 
 </html> 
```

Вышеприведенный код довольно прост. Однако самое главное не хватает. Вам необходимо проверить данные формы, чтобы защитить ваш скрипт от вредоносного кода.

> **Думайте БЕЗОПАСНОСТЬ при обработке PHP-форм!**
> 
> Эта страница не содержит проверки формы, она просто показывает, как вы можете отправлять и извлекать данные формы.
> 
> Однако на следующих страницах будет показано, как обрабатывать формы PHP с учетом безопасности! Правильная проверка данных формы важна для защиты вашей формы от хакеров и спамеров!

### GET против POST

И GET, и POST создают массив (например, array (key => value, key2 => value2, key3 => value3, ...)). Этот массив содержит пары ключ / значение, где ключи - это имена элементов управления формой, а значения - это входные данные пользователя.

И GET, и POST обрабатываются как $ _GET и $_ POST. Это суперглобалы, что означает, что они всегда доступны независимо от области видимости - и вы можете получить к ним доступ из любой функции, класса или файла без необходимости делать что-либо особенное.

$ \_GET - это массив переменных, переданных текущему скрипту через параметры URL.

$ \_POST - это массив переменных, переданных текущему скрипту через метод HTTP POST.

### Когда использовать GET?

Информация, отправленная из формы с помощью метода GET, видна всем (все имена переменных и значения отображаются в URL-адресе). GET также имеет ограничения на объем отправляемой информации. Ограничение составляет около 2000 символов. Однако, поскольку переменные отображаются в URL-адресе, можно пометить страницу. Это может быть полезно в некоторых случаях.

GET может использоваться для отправки нечувствительных данных.

**Примечание.** GET никогда не должен использоваться для отправки паролей или другой конфиденциальной информации!

### Когда использовать POST?

Информация, отправленная из формы с методом POST, **невидима для других** (все имена / значения встроены в тело HTTP-запроса) и не **имеет ограничений** на количество отправляемой информации.

Кроме того, POST поддерживает расширенные функции, такие как поддержка многочастного двоичного ввода при загрузке файлов на сервер.

Однако, поскольку переменные не отображаются в URL-адресе, закладка страницы невозможно.

> **Разработчики предпочитают POST для отправки данных формы.**