---
title: PHP functions
localeTitle: Функции PHP
---
Функции PHP похожи на другие языки программирования. Функция представляет собой фрагмент кода, который принимает еще один вход в виде параметра и выполняет некоторую обработку и возвращает значение.

Вы уже видели много функций, таких как fopen () и fread () и т. Д. Они встроены в функции, но PHP дает вам возможность создавать свои собственные функции.

Есть две части, которые должны быть понятны вам -

### Создание функции PHP

Вызов функции PHP На самом деле вам вряд ли нужно создавать свою собственную функцию PHP, потому что уже существует более 1000 встроенных функций библиотеки, созданных для разных областей, и вам просто нужно позвонить им в соответствии с вашими требованиями.

Пожалуйста, обратитесь к Справочнику по функциям PHP для полного набора полезных функций.

Создание функции PHP Его очень легко создать собственную функцию PHP. Предположим, вы хотите создать функцию PHP, которая просто напишет простое сообщение в вашем браузере, когда вы его назовете. Следующий пример создает функцию writeMessage (), а затем вызывает ее сразу после ее создания.

Обратите внимание, что при создании функции его имя должно начинаться с функции ключевого слова, и весь код PHP должен быть помещен внутри скобок {и}, как показано в следующем примере ниже -
```
<html> 
 
   <head> 
      <title>Writing PHP Function</title> 
   </head> 
 
   <body> 
 
      <?php 
         /* Defining a PHP Function */ 
         function writeMessage() { 
            echo "You are really a nice person, Have a nice time!"; 
         } 
 
         /* Calling a PHP Function */ 
         writeMessage(); 
      ?> 
 
   </body> 
 </html> 
```

На этом отобразится следующий результат -
```
You are really a nice person, Have a nice time! 
```

### Функции PHP с параметрами

PHP дает вам возможность передавать свои параметры внутри функции. Вы можете передать столько параметров, сколько хотите. Эти параметры работают как переменные внутри вашей функции. Следующий пример берет два целочисленных параметра и объединяет их, а затем печатает их.
```
<html> 
 
   <head> 
      <title>Writing PHP Function with Parameters</title> 
   </head> 
 
   <body> 
 
      <?php 
         function addFunction($num1, $num2) { 
            $sum = $num1 + $num2; 
            echo "Sum of the two numbers is : $sum"; 
         } 
 
         addFunction(10, 20); 
      ?> 
 
   </body> 
 </html> 
```

На этом отобразится следующий результат -
```
Sum of the two numbers is : 30 
```

### Передача аргументов по ссылке

Можно передавать аргументы в функции по ссылке. Это означает, что ссылка на переменную управляется функцией, а не копией значения переменной.

Любые изменения, внесенные в аргумент в этих случаях, изменят значение исходной переменной. Вы можете передать аргумент по ссылке, добавив амперсанд к имени переменной либо в вызове функции, либо в определении функции.

В следующем примере изображены оба случая.
```
<html> 
 
   <head> 
      <title>Passing Argument by Reference</title> 
   </head> 
 
   <body> 
 
      <?php 
         function addFive($num) { 
            $num += 5; 
         } 
 
         function addSix(&$num) { 
            $num += 6; 
         } 
 
         $orignum = 10; 
         addFive( $orignum ); 
 
         echo "Original Value is $orignum<br />"; 
 
         addSix( $orignum ); 
         echo "Original Value is $orignum<br />"; 
      ?> 
 
   </body> 
 </html> 
```

На этом отобразится следующий результат -
```
Original Value is 10 
 Original Value is 16 
```

### Функции PHP, возвращающие значение

Функция может возвращать значение с помощью оператора return в сочетании со значением или объектом. return останавливает выполнение функции и отправляет значение обратно вызывающему коду.

Вы можете вернуть более одного значения из функции с использованием возвращаемого массива (1,2,3,4).

Следующий пример принимает два целочисленных параметра и объединяет их вместе, а затем возвращает их сумму в вызывающую программу. Обратите внимание, что ключевое слово return используется для возврата значения из функции.
```
<html> 
 
   <head> 
      <title>Writing PHP Function which returns value</title> 
   </head> 
 
   <body> 
 
      <?php 
         function addFunction($num1, $num2) { 
            $sum = $num1 + $num2; 
            return $sum; 
         } 
         $return_value = addFunction(10, 20); 
 
         echo "Returned value from the function : $return_value"; 
      ?> 
 
   </body> 
 </html> 
```

На этом отобразится следующий результат -
```
Returned value from the function : 30 
```

### Установка значений по умолчанию для функциональных параметров

Вы можете установить для параметра значение по умолчанию, если вызывающий объект функции не передает его.

Следующая функция печатает значение NULL в случае, если использование этой функции не передается.
```
<html> 
 
   <head> 
      <title>Writing PHP Function which returns value</title> 
   </head> 
 
   <body> 
 
      <?php 
         function printMe($param = NULL) { 
            print $param; 
         } 
 
         printMe("This is test"); 
         printMe(); 
      ?> 
 
   </body> 
 </html> 
```

Это приведет к следующему результату -
```
This is test 
```

### Динамические вызовы функций

Можно назначать имена функций как строки для переменных, а затем обрабатывать эти переменные точно так же, как и имя функции. Следующий пример изображает это поведение.
```
<html> 
 
   <head> 
      <title>Dynamic Function Calls</title> 
   </head> 
 
   <body> 
 
      <?php 
         function sayHello() { 
            echo "Hello<br />"; 
         } 
 
         $function_holder = "sayHello"; 
         $function_holder(); 
      ?> 
 
   </body> 
 </html> 
```

На этом отобразится следующий результат -
```
Hello 

```