---
title: PHP Operators
localeTitle: Операторы PHP

---
## Операторы PHP

### Приоритет оператора

	Операторы в PHP, как и в математике, имеют свои приоритеты в выражениях. 
		Например:
		Выражение "2 + 5 * 2" вычисляется как "12", а не "14", поскольку оператор умножения ("*") имеет более высокий приоритет, чем оператор 	сложения ("+").
		
	Круглые скобки могут использоваться для принудительного указания порядка выполнения операторов.
		Например:
		Выражение "(2 + 3) * 4" вычисляется как "20".
	
	Если операторы имеют равный приоритет, то будут ли они выполняться справа налево или слева направо определяется их ассоциативностью.
		Например:
		"-" является лево-ассоциативным оператором. Следовательно "3 - 5 - 7" сгруппируется как "(3 - 5) - 7" и пересчитается в "-9".
		С другой стороны "=" - это право-ассоциативный оператор, так что "$a = $b = $c" сгруппируется как "$a = ($b = $c)".
		
	Неассоциативные операторы с одинаковым приоритетом не могут использоваться совместно.
		Например:
		"1 < 2 > 1" не будет работать в PHP. Выражение "1 <= 1 == 1", с другой стороны, будет, поскольку "==" имеет более низкий приоритет чем "<=".
		
### Арифметические операторы

	Арифметические операторы в PHP работают идентично арифметическим выражениям в математике.
	
	Ниже указан список арифметических операторов PHP.
#### Идентичность
	Конвертация $a в int или float, что более подходит.
	
	+$a

#### Отрицание
	Смена знака $a.
	
	-$a

#### Сложение
	Сумма $a и $b.
	
	<?php
		echo (4 + 2)."\n";			// выводит 6
	?>
	
#### Вычитание
	Разность $a и $b.
	
	<?php
		echo (4 - 2)."\n";			// выводит 2
	?>
	
#### Умножение
	Произведение $a и $b.
	
	<?php
		echo (4 * 2)."\n";			// выводит 8
	?>
	
#### Деление
	Частное от деления $a на $b.
	
	<?php
		echo (4 / 2)."\n";			// выводит 2
	?>
	
#### Деление по модулю
	Целочисленный остаток от деления $a на $b.
	
	<?php
		echo (5 % 2)."\n";			// выводит 1
	?>
	
#### Возведение в степень
	Возведение $a в степень $b. Добавлено в PHP 5.6.
	
	<?php
		echo (4 ** 2)."\n";			// выводит 16
	?>
	
### Оператор присваивания

	Базовый оператор присваивания обозначается символом "=".
	Оператор присваивания означает, что левый операнд получает значение правого выражения.
	
	Результатом выполнения оператора присваивания является само присвоенное значение:
 
	<?php
		$a = 3;
		echo $a;			// выводит 3
	?>
	
	<?php
		$a = ($b = 3) + 4;			// $a теперь равно 7, а $b было присвоено 3.
	?>
	
### Строковые операторы

	В PHP есть два оператора для работы со строками (string):
		Первый - оператор конкатенации ('.'), который возвращает строку, представляющую собой соединение левого и правого аргумента.
		Второй - оператор присваивания с конкатенацией ('.='), который присоединяет правый аргумент к левому.
		
	<?php
		$a = "Привет, ";
		$b = $a . "Мир!"; 		// $b теперь содержит строку "Привет, Мир!"

		$a = "Привет, ";
		$a .= "Мир!";     		// $a теперь содержит строку "Привет, Мир!"
	?>
	
### Логические операторы

	Логические операторы позволяют сравнивать результаты работы двух операндов (значения или выражения) с целью определения факта 	
	возвращения одним из них или обоими значения true или false.
	
#### Оператор "И"
	TRUE, если и $a, и $b TRUE.
	
	$a and $b;
	$a && $b
	
#### Оператор "ИЛИ"
	TRUE, если или $a, или $b TRUE.
	
	$a or $b;
	$a || $b
	
#### Оператор "Исключающее ИЛИ"
	TRUE, если $a, или $b TRUE, но не оба.
	
	$a xor $b
	
#### Оператор "Отрицание"
	TRUE, если $a не TRUE.
	
	! $a
	
### Операторы сравнения

	Данные операторы позволяют сравнивать между собой два значения.
	
#### Равно
	TRUE если $a равно $b после преобразования типов.
	
	$a == $b
	
#### Тождественно равно
	TRUE если $a равно $b и имеет тот же тип.
	
	$a === $b
	
#### Не равно
	TRUE если $a не равно $b после преобразования типов.
	
	$a != $b
		или
	$a <> $b
	
#### Тождественно не равно
	TRUE если $a не равно $b, или они разных типов.
	
	$a !== $b
	
#### Меньше
	TRUE если $a строго меньше $b.
	
	$a < $b
	
#### Больше
	TRUE если $a строго больше $b.
	
	$a > $b
	
#### Меньше или равно
	TRUE если $a меньше или равно $b.
	
	$a <= $b
	
#### Больше или равно
	TRUE если $a больше или равно $b.
	
	$a >= $b
	
#### Космический корабль
	Число типа integer меньше, больше или равное нулю, когда $a соответственно меньше, больше или равно $b.
	*Доступно c PHP 7.
	
	$a <=> $b
	
### Операторы инкремента и декремента

	В PHP есть поддержка префиксных и постфиксных операторов инкремента и декремента в стиле языка C.
	
	*Операторы инкремента и декремента не влияют на значение boolean.
	 Декремент NULL также не даст никакого эффекта, однако инкремент даст значение 1.
	 
#### Префиксный инкремент
	Увеличивает $a на единицу, затем возвращает значение $a.
	
	++$a
	
#### Постфиксный инкремент
	Возвращает значение $a, затем увеличивает $a на единицу.
	
	$a++
	
#### Префиксный декремент
	Уменьшает $a на единицу, затем возвращает значение $a.
	
	--$a
	
#### Постфиксный декремент
	Возвращает значение $a, затем уменьшает $a на единицу.
		
	$a-- .
	
	
	






#### Дополнительная информация:
[Операторы в PHP](http://php.net/manual/ru/language.operators.php)

