---
title: PHP strings
localeTitle: Строки PHP
---
Это последовательности символов, например «PHP поддерживает строковые операции».

ПРИМЕЧАНИЕ. - Встроенные строковые функции приведены в описании функций. PHP String Functions

Ниже приведены допустимые примеры строки

$ string _1 = "Это строка в двойных кавычках"; $ string_ 2 = "Это несколько более длинная, одинарная кавычка"; $ string _39 = "Эта строка содержит тридцать девять символов"; $ string_ 0 = ""; // строка с нулевыми символами Одиночные строки цитируются почти буквально, тогда как строки с двойным цитированием заменяют переменные своими значениями, а также специально интерпретируют определенные последовательности символов.
```
<?php 
   $variable = "name"; 
   $literally = 'My $variable will not print!\\n'; 
 
   print($literally); 
   print "<br />"; 
 
   $literally = "My $variable will print!\\n"; 
 
   print($literally); 
 ?> 
```

Это приведет к следующему результату -
```
My $variable will not print!\n 
 My name will print 
```

Нет никаких искусственных ограничений на длину строки - в пределах доступной памяти вы должны иметь возможность делать сколь угодно длинные строки.

Строки, разделенные двойными кавычками (как в «этом»), предварительно обрабатываются двумя следующими способами: PHP -

Определенные последовательности символов, начинающиеся с обратного слэша (), заменяются специальными символами

Имена переменных (начиная с $) заменяются строковыми представлениями их значений.

Замена последовательности escape-последовательности -

\\ n заменяется символом новой строки \\ r заменяется символом возврата каретки \\ t заменяется символом табуляции \\ $ заменяется самим значком доллара ($) \\ "заменяется одной двойной кавычкой (") \\ заменяется одним обратным слэшем ()

### Оператор конкатенации строк

Чтобы объединить две строковые переменные вместе, используйте оператор точки (.) -
```
<?php 
   $string1="Hello World"; 
   $string2="1234"; 
 
   echo $string1 . " " . $string2; 
 ?> 
```

Это приведет к следующему результату -
```
Hello World 1234 
```

Если мы посмотрим на код выше, вы увидите, что мы использовали оператор конкатенации два раза. Это потому, что нам пришлось вставить третью строку.

Между двумя строковыми переменными мы добавили строку с единственным символом - пустым пространством для разделения двух переменных.

### Использование функции strlen ()

Функция strlen () используется для определения длины строки.

Давайте найдем длину нашей строки «Hello world!»:
```
<?php 
   echo strlen("Hello world!"); 
 ?> 
```

Это приведет к следующему результату -
```
12 
```

Длина строки часто используется в циклах или других функциях, когда важно знать, когда строка заканчивается. (т. е. в цикле мы хотели бы остановить цикл после последнего символа в строке)

### Использование функции strpos ()

Функция strpos () используется для поиска строки или символа в строке.

Если совпадение найдено в строке, эта функция вернет позицию первого совпадения. Если совпадение не найдено, оно вернет FALSE.

Давайте посмотрим, можем ли мы найти строку «мир» в нашей строке -
```
<?php 
   echo strpos("Hello world!","world"); 
 ?> 
```

Это приведет к следующему результату -
```
 6 
```

Как вы видите, позиция строки «мир» в нашей строке - это позиция 6. Причина, по которой это 6, а не 7, заключается в том, что первая позиция в строке равна 0, а не 1.