---
title: PHP Variables
localeTitle: Переменные PHP
---
### Переменные в PHP

  Переменные - это основной способ хранения информации в середине программы PHP. Все переменные в PHP передаются с помощью знака доллара, как `$variable_name` . Переменные присваиваются оператором `=`, с переменной в левой части и его присваиваемым значением справа.

```PHP
<?php 
 $myVariable = "Hello World"; 
 $x = 5; 
 $y = 10.5; 
 $z = '42'; 
 ?> 
```

#### Переменные имена

  Правила для именования переменной перечислены ниже:

  1. Имена переменных должны начинаться с буквы или символа подчеркивания.
  2. Имя переменной может состоять из цифр, букв, подчеркиваний, но вы не можете использовать символы, такие как `+ , - , % , ( , ) . &`
  в его названии.
  3. Переменные имена чувствительны к регистру, т.е. `($age and $AGE are two different variables)`.

   * $this - это специальная переменная, которой нельзя ничего присваивать.

### Создание (объявление) переменных PHP

  В PHP переменная начинается со знака $, а затем имя переменной.

```PHP
<?php $txt = "Hello world!"; $x = 6; $y = 10.5; ?>
```

#### Переменные переменных

  Это способ иметь переменными имена переменных. Имя переменной может быть динамически определено и изменено.
Например, обычная переменная определяется следующим выражением:

```PHP
  <?php
    $a = 'hello';
  ?>
```

  Переменная переменной берет значение первой переменной и рассматривает его как имя второй переменной. В вышеприведенном примере "hello" может быть использовано как имя второй переменной:

```PHP
  <?php
    $$a = 'world';
  ?>
```

 Теперь в дереве символов PHP определены и содержатся две переменные: $a, содержащая "hello" и $hello, содержащая "world". Таким образом, имеем, что выражение

```PHP
  <?php
    echo "$a ${$a}";
  ?>
```

  будет выводить то же, что и

```PHP
  <?php
    echo "$a $hello";     // hello world
  ?>
```


    
  ### Дополнительная информация:
*   [Переменные в PHP](http://php.net/manual/ru/language.variables.php).
