---
title: PHP Sessions
localeTitle: Сеансы PHP
---
# Сеансы PHP

Сессия - способ хранения информации (в переменных), которая будет использоваться на нескольких страницах.  
В отличие от файла cookie, информация не сохраняется на компьютере пользователя.

## Что такое сеанс PHP?

Когда вы работаете с приложением, вы открываете его, делаете некоторые изменения и закрываете его. Это очень похоже на сеанс.  
Компьютер знает, кто вы. Он знает, когда вы запускаете приложение и когда закончите.  
Но в Интернете есть одна проблема: веб-сервер не знает, кто вы и что вы делаете, потому что HTTP-адрес _не поддерживает состояние_ .

Переменные сеанса решают эту проблему, сохраняя информацию пользователя, которая будет использоваться на нескольких страницах (например, имя пользователя, любимый цвет и т. Д.).  
По умолчанию переменные сеанса сохраняются до тех пор, пока пользователь не закроет браузер.

**Переменные сеанса содержат информацию об одном пользователе и доступны для всех страниц в одном приложении.**

**Примечание.** Если вам требуется постоянное хранилище, вы можете захотеть сохранить данные в базе данных.

## Начало сеанса PHP

Сессия начинается с функции start () \_ _session_ .  
Переменные сеанса задаются с помощью глобальной переменной PHP: $ \_SESSION.

**Пример:**
```
<?php 
 // Start the session 
 session_start(); 
 ?> 
 <!DOCTYPE html> 
 <html> 
 <body> 
 
 <?php 
 // Set session variables 
 $_SESSION["favcolor"] = "blue"; 
 $_SESSION["favanimal"] = "dog"; 
 echo "Session variables are set."; 
 ?> 
 
 </body> 
 </html> 
```

**Примечание.** Функция session\_start () должна быть **первой** в вашем документе. **Перед** любыми тегами HTML.

Вывод:  
Параметры сеанса установлены.

## Получить значения переменных сеанса PHP

Обратите внимание, что переменные сеанса не передаются отдельно для каждой новой страницы, вместо этого они извлекаются из сеанса, который мы открываем в начале каждой страницы (session\_start ()).

Также обратите внимание, что все значения переменной сеанса хранятся в глобальной переменной $ \_SESSION:

**Пример:**
```
<?php 
 session_start(); 
 ?> 
 <!DOCTYPE html> 
 <html> 
 <body> 
 
 <?php 
 // Echo session variables that were set on previous page 
 echo "Favorite color is " . $_SESSION["favcolor"] . ".<br>"; 
 echo "Favorite animal is " . $_SESSION["favanimal"] . "."; 
 ?> 
 
 </body> 
 </html> 
```

Вывод:  
Любимый цвет - синий.  
Любимое животное - собака.

Другой способ показать все значения переменной сеанса для сеанса пользователя - запустить следующий код:
```
<?php 
 print_r($_SESSION); 
 ?> 
```

### Как это работает?

В большинстве сеансов пользовательский ключ на компьютере пользователя выглядит примерно так: 765487cf34ert8dede5a562e4f3a7e12.  
Затем, когда сеанс открывается на другой странице, он сканирует компьютер для пользовательского ключа.  
Если есть совпадение, он обращается к этому сеансу, если нет, он запускает новый сеанс.

## Изменение переменной сеанса

Чтобы изменить переменную сеанса, просто перепишите ее:

**Пример:**
```
<?php 
 session_start(); 
 ?> 
 <!DOCTYPE html> 
 <html> 
 <body> 
 
 <?php 
 // to change a session variable, just overwrite it 
 $_SESSION["favcolor"] = "pink"; 
 print_r($_SESSION); 
 ?> 
 
 </body> 
 </html> 
```

## Уничтожьте сеанс PHP

Чтобы удалить все глобальные переменные сеанса и уничтожить сеанс, используйте _session_ unset () \_ и _session_ destroy () \_:

**Пример:**
```
<?php 
 session_start(); 
 ?> 
 <!DOCTYPE html> 
 <html> 
 <body> 
 
 <?php 
 // remove all session variables 
 session_unset(); 
 
 // destroy the session 
 session_destroy(); 
 ?> 
 
 </body> 
 </html> 

```