---
title: Cross Site Scripting
localeTitle: Скрипты для сайта
---
## Скрипты для сайта

Cross Site Scripting - это тип уязвимости в веб-приложении, вызванный тем, что программист не дезинфицирует входные данные перед выдачей ввода в веб-браузер (например, комментарий к блогу). Он обычно используется для запуска вредоносного javascript в веб-браузере для совершения таких атак, как кража сеансовых файлов cookie среди других вредоносных действий для получения привилегий более высокого уровня в веб-приложении.

### Пример атаки на скрипт

Блог позволяет пользователям создавать свои комментарии с помощью HTML-тегов, однако сценарий, запускающий блог, не выделяет теги `<script>` позволяющие любому пользователю запускать javascript на странице. Злоумышленник может использовать это в своих интересах для запуска вредоносного javascript в браузере. Они могут заражать пользователей вредоносным ПО, кражи сеансовых файлов и т. Д.

```HTML
<script> 
  alert('Cross Site Scripting!'); 
 </script> 
```

### Защита вашего сайта от межсайтовых скриптовых атак в PHP

В PHP есть две основные функции: `htmlspecialchars()` и `strip_tags()` , встроенные для защиты от атак с межсайтового скриптинга.

Функция `htmlspecialchars($string)` предотвратит отображение HTML-строки в виде HTML и отображение ее в виде обычного текста в веб-браузере. **Пример кода htmlspecialchars ()**

```PHP
<?php 
 $usercomment = "<string>alert('Cross Site Scripting!');</script>"; 
 echo htmlspecialchars($usercomment); 
```

Другим подходом является `strip_tags($string, $allowedtags)` которая удаляет все теги HTML, за исключением HTML-тегов, которые вы указали в белый список. Важно отметить, что с помощью функции `strip_tags()` вы должны быть более осторожны, эта функция не мешает пользователю включать javascript в качестве ссылки, вам придется самостоятельно дезинформировать его.

**Пример примера strip\_tags ()**

```php
<?php 
 $usercomment = "<string>alert('Cross Site Scripting!');</script>"; 
 $allowedtags = "<p><a><h1><h2><h3>"; 
 echo strip_tags($usercomment, $allowedtags); 
```

**Установка заголовка X-XSS-Protection:**

В PHP вы можете отправить заголовок `X-XSS-Protection` Header, который будет указывать браузерам на проверку отраженной атаки Cross Site Scripting и блокировку загрузки страницы. Это не мешает всем атакам сценариев межсайтового взаимодействия только отражать их и их следует использовать в сочетании с другими методами.

```PHP
<?php 
 header("X-XSS-Protection: 1; mode=block"); 
```

**Написание собственной функции дезинфекции** Другой вариант, если вы хотите получить больше контроля над тем, как работает санитария, заключается в том, чтобы написать собственную функцию санитаризации HTML, это не рекомендуется для начинающих PHP, поскольку ошибка сделает ваш сайт уязвимым.

### Защита вашего сайта от атак с использованием межсайтовых скриптов с помощью политики безопасности контента

Эффективный подход к предотвращению атак на сценарии межсайтового сценария, который может потребовать больших корректировок в структуре и базе данных вашего веб-приложения, заключается в использовании политики безопасности контента.

#### Задайте политику безопасности содержимого как заголовок HTTP

Наиболее распространенным способом установки политики безопасности контента является установка его непосредственно в заголовке HTTP. Это можно сделать с помощью веб-сервера, отредактировав его конфигурацию или отправив его через PHP.

**Пример политики безопасности контента, заданной в заголовке HTTP**

```php
<?php 
 header("content-security-policy: default-src 'self'; img-src https://*; child-src 'none';"); 
```

#### Установите политику безопасности контента как метатег

Вы можете включить свою политику безопасности контента в HTML-страницу страницы и установить ее на странице. Этот метод требует, чтобы вы установили на каждой странице или потеряли преимущество политики.

**Пример политики безопасности контента, установленной в метатеге HTML**

```HTML
<meta http-equiv="Content-Security-Policy" content="default-src 'self'; img-src https://*; child-src 'none';"> 
```

#### Дополнительная информация:

*   [OWASP Wiki - Скрипты между сайтами](https://www.owasp.org/index.php/Cross-site_Scripting_(XSS))
*   [Руководство пользователя php.net strip\_tags ()](https://secure.php.net/manual/en/function.strip-tags.php)
*   [Руководство пользователя php.net htmlspecialchars ()](https://secure.php.net/manual/en/function.htmlspecialchars.php)
*   [MDN - Политика безопасности контента (CSP)](https://developer.mozilla.org/en-US/docs/Web/HTTP/CSP)