---
title: Security
localeTitle: Безопасность
---
## Безопасность

При написании PHP-кода очень важно получить соображения безопасности, чтобы избежать написания уязвимого кода.

### Типы уязвимостей

*   [Cross-Site Request Forgery](/php/security/cross-site-request-forgery) Уязвимость в приложении, вызванная программистом, не проверяющим, откуда был отправлен запрос, - эта атака отправляется пользователю с высоким уровнем привилегий, чтобы получить доступ к приложению более высокого уровня.
*   [Cross Site Scripting](/php/security/cross-site-scripting) Уязвимость в приложении, вызванная тем, что программист не дезинфицирует входные данные перед выдачей ввода в браузер (например, комментарий к блогу). Он обычно используется для запуска вредоносного javascript в браузере для совершения таких атак, как кража файлов сеансов cookie среди других вредоносных действий для получения привилегий более высокого уровня в приложении.
*   [Включение локального файла](/php/security/local-file-inclusion) . Уязвимость в приложении, вызванная программистом, требующая ввода файла, предоставленного пользователем, а не дезинфекция ввода перед доступом к запрашиваемому файлу. Это приводит к включению файла, где он не должен быть.
*   [Включение удаленного файла](/php/security/remote-file-inclusion) Уязвимость в приложении, вызванная программистом, требующая ввода файла, предоставленного пользователем, а не дезинфекция ввода перед доступом к запрашиваемому файлу. Это приводит к тому, что файл удаляется с удаленного сервера и включается там, где он не должен быть.
*   [Захват сеанса](/php/security/session-hijacking) Уязвимость, вызванная тем, что злоумышленник получает доступ к идентификатору сеанса пользователя и может использовать учетную запись другого пользователя, олицетворяя их. Это часто используется для доступа к учетной записи администратора.
*   [Идентификатор](/php/security/session-identifier-acquirement) сеанса идентификации [идентификатора](/php/security/session-identifier-acquirement) сеанса Приобретение - это уязвимость, вызванная тем, что злоумышленник может либо угадать идентификатор сеанса пользователя, либо использовать уязвимости в самом приложении или в браузере пользователя для получения идентификатора сеанса.
*   [SQL Injection](/php/security/sql-injection) Уязвимость в приложении, вызванная тем, что программист не дезинфицирует ввод, прежде чем включать его в запрос в базу данных. Это приводит к тому, что злоумышленник имеет полное чтение и чаще всего не пишет доступ к базе данных. При таком типе доступа злоумышленник может делать очень плохие вещи.

#### Дополнительная информация:

[Страница атаки WWASP Wiki](https://www.owasp.org/index.php/Category:Attack)