---
title: Session Identifier Acquirement
localeTitle: Приобретение идентификатора сеанса
---
## Приобретение идентификатора сеанса

Идентификатор сеанса Приобретение - это уязвимость, вызванная тем, что злоумышленник может либо угадать идентификатор сеанса пользователя, либо использовать уязвимости в самом приложении или в браузере пользователя для получения идентификатора сеанса. Эта атака является предварительным условием для выполнения атаки на захват сеанса.

### пример

У злоумышленника есть несколько вариантов выполнения атаки на получение идентификатора сеанса.

*   Угадайте идентификатор: короткий и допустимый идентификатор сеанса может позволить злоумышленнику перевести идентификатор сеанса и войти в него.
*   Атака на браузер: если вы храните идентификатор сеанса в кукисах браузера - если ваш сайт уязвим для межсайтового скриптинга, злоумышленник может использовать эту уязвимость для сбора куки-файлов с идентификаторами сеансов и доступа к областям с высоким уровнем привилегий (например, панель администратора) ,
*   Изменение идентификатора на выбор злоумышленника: в более старых версиях PHP вы могли установить идентификатор сеанса в URL-адресе. Теперь он отключен по умолчанию, если у вас есть сомнения, убедитесь, что `session.use_trans_sid` является ложным. Это уже не обычная проблема, но все равно это может произойти, лучше, чем жаль.

### Защита от атак Session Identifier в PHP

Для защиты от атак типа «Идентификатор сеанса» вам необходимо проверить попытку доступа к сеансу с несколькими факторами, чтобы убедиться, что это законный доступ и чтобы пользователь не смог успешно захватить сеанс пользователя. Ниже приведен пример реализации, который может помочь смягчить последствия атаки на получение идентификатора сеанса. Он проверяет IP-адрес, Пользовательский агент, и если сеанс Истек, удаление сеанса перед его приобретением.

```PHP
<?php 
 session_start(); 
 
 // Does IP Address match? 
 if ($_SERVER['REMOTE_ADDR'] != $_SESSION['ipaddress']) 
 { 
 session_unset(); 
 session_destroy(); 
 } 
 
 // Does user agent match? 
 if ($_SERVER['HTTP_USER_AGENT'] != $_SESSION['useragent']) 
 { 
  session_unset(); 
  session_destroy(); 
 } 
 
 // Is the last access over an hour ago? 
 if (time() > ($_SESSION['lastaccess'] + 3600)) 
 { 
  session_unset(); 
  session_destroy(); 
 } 
 else 
 { 
  $_SESSION['lastaccess'] = time(); 
 } 
```

**Подсказки:**

*   Храните много информации о текущем сеансе (строка агента пользователя, IP-адрес, время последнего доступа и т. Д.).
*   Проверяйте каждый запрос в отношении информации, хранящейся в сеансе (соответствует ли она? Если не удалять сеанс и требуется повторная регистрация пользователя)
*   Сеансы не должны длиться вечно - они должны истечь в определенный момент, чтобы поддерживать безопасность сеанса.
*   Скорость ограничивает количество сеансов, к которым пользователь может попытаться получить доступ (пользователь попытался получить доступ к 1000 + недействительным сеансам? Скорее всего, они угадывают - не позволяйте IP-адресу пытаться больше сеансов в течение нескольких часов).

#### Дополнительная информация:

*   [Руководство по безопасности сессии php.net](https://secure.php.net/manual/en/session.security.php)