---
title: Variables
localeTitle: переменные
---
## переменные

# Создание (объявление) переменных PHP

Переменные - это «контейнеры» для хранения информации.

**Синтаксис:**

```php
<?php 
 $txt = "Hello world!"; 
 $x = 5; 
 $y = 10.5; 
 ?> 
```

После выполнения вышеприведенных выводов переменная $ txt будет содержать значение Hello world !, переменная $ x будет содержать значение 5, а переменная $ y будет удерживать значение 10.5.

##### Примечание. Когда вы назначаете текстовое значение переменной, поместите кавычки вокруг значения.

##### Примечание. В отличие от других языков программирования, PHP не имеет команды для объявления переменной. Он создается в тот момент, когда вы сначала назначили ему значение.

# Правила для переменных PHP:

*   Переменная начинается с знака $, за которым следует имя переменной
*   Имя переменной должно начинаться с буквы или символа подчеркивания
*   Имя переменной не может начинаться с числа
*   Имя переменной может содержать только буквенно-цифровые символы и символы подчеркивания (Az, 0-9 и \_)
*   Имена переменных зависят от регистра ($ age и $ AGE - это две разные переменные)

# Выходные переменные

PHP echo statement часто используется для вывода данных на экран.

В следующем примере показано, как выводить текст и переменную:

```php
<?php 
 $txt = "github.com"; 
 echo "I love $txt!"; 
 ?> 
```

Следующий пример даст тот же результат, что и пример выше:

```php
<?php 
 $txt = "github.com"; 
 echo "I love " . $txt . "!"; 
 ?> 
```

В следующем примере выведите сумму двух переменных:

```php
<?php 
 $x = 5; 
 $y = 4; 
 echo $x + $y; 
 ?> 
```

# PHP - это типичный язык

В приведенном выше примере обратите внимание, что нам не нужно было указывать PHP, какой тип данных является переменной. PHP автоматически преобразует переменную в правильный тип данных, в зависимости от ее значения. В других языках, таких как C, C ++ и Java, программист должен объявить имя и тип переменной перед ее использованием.

#### Дополнительная информация: