---
title: Progressive Web Apps
localeTitle: Прогрессивные веб-приложения
---
## Прогрессивные веб-приложения

Прогрессивные веб-приложения или «PWA» кажутся не просто прихотью, но принципиально отличным способом приближения к тому, что веб-сайт может и должен быть на любой платформе, от которой вы ее просматриваете.

PWA могут устанавливать часть себя на устройства для автономного просмотра, использовать сервис-работников для доставки контента по мере необходимости, когда соединение доступно, и лучше всего стандартизировать определенные функции между мобильными и настольными устройствами.

### Особенности

Конкретные особенности PWA включают:

*   **отзывчивый**
*   подходит для любого форм-фактора
*   **Автономные возможности**
*   с прогрессивным улучшением с Service Workers, чтобы позволить им работать в автономном режиме
*   **Собственное приложение**
*   использует модель приложения Shell & Content для создания навигации и взаимодействия приложений
*   **пресная**
*   благодаря современным сервисным работникам
*   **Безопасный**
*   обслуживается через TLS (требование Рабочего Работника), чтобы предотвратить отслеживание
*   **Видимый**
*   идентифицируется как «приложения» благодаря W3C Manifests и области регистрации рабочего персонала, что позволяет поисковым системам находить их
*   **обаятельный**
*   может получить доступ к пользовательским интерфейсам повторного взаимодействия ОС посредством Push-уведомлений
*   **Простая установка**
*   могут быть добавлены на главный экран через предоставленные браузером подсказки, позволяющие пользователям «сохранять» приложения, которые они находят наиболее полезными, без хлопот магазина приложений
*   **связываемый**
*   что означает, что они имеют нулевое трение, нуль-установку и легко делить
*   социальная сила URL-адресов

> Эти приложения не упакованы и не развернуты через магазины, а просто веб-сайты, на которых все правильные витамины. 1

### Прогрессивное улучшение

Прогрессивное улучшение означает, что каждый может получить доступ к базовому контенту и функциональности страницы в любом браузере, а те, у кого нет определенных функций браузера, могут получить уменьшенный, но все же функциональный опыт. [\- Маяк](https://medium.com/@addyosmani/progressive-web-apps-with-react-js-part-4-site-is-progressively-enhanced-b5ad7cf7a447) 2

Большая аналогия с [Аароном Густафсоном](http://alistapart.com/article/understandingprogressiveenhancement) заключается в том, что прогрессивное улучшение (PE) похоже на арахис M & M.

> «Арахис - это ваше содержание, шоколадное покрытие - это ваш слой презентации, и ваш JavaScript - это каракули».

Это означает, что в зависимости от браузера, опыт может измениться.

### демонстрация

### Рекомендации

1.  [Рассел, Алекс. «Прогрессивные веб-приложения: экранирование вкладок без потери нашей души» «Нечасто отмечено» Опубликовано: 15 июня 2015 года.](https://infrequently.org/2015/06/progressive-apps-escaping-tabs-without-losing-our-soul/)
2.  [Прогрессивные веб-приложения - разработчики Google](https://developers.google.com/web/progressive-web-apps/)