---
title: Basic Operators
localeTitle: Основные операторы
---
## Основные операторы

Операторы - это символы, которые говорят интерпретатору выполнять определенную операцию (арифметику, сравнение, логику и т. Д.),

Ниже перечислены различные типы операторов в Python:

1.  Арифметические операторы
2.  Реляционные операторы
3.  Побитовые операторы
4.  Операторы присваивания
5.  Логические операторы
6.  Операторы членства
7.  Операторы идентификации

#### Арифметические операторы

Арифметический оператор принимает два операнда в качестве входных данных, выполняет вычисление и возвращает результат.

Рассмотрим выражение **«a = 2 + 3»** . Здесь `2` и `3` - _операнды,_ а `+` - _арифметический оператор_ . Результат операции хранится в переменной a.

оператор

Описание

использование

+

Выполняет добавление в операндах

12 + 3 = 15

\-

Выполняет вычитание на операндах. Вычитает правый операнд из левого операнда

12 - 3 = 9

\*

Выполняет умножение на операнды

12 \* 3 = 36

/

Выполняет разделение на операнды. Делит левый операнд на правый операнд

12/3 = 4

Примечание. Когда используются два целых числа, результат отличается между Python 2 и Python 3.

5/2 = 2 в Python 2

5/2 = 2,5 в Python 3

%

Выполняет модуль для операндов. Возвращает остаток, полученный при делении левого операнда на правый операнд

16% 3 = 1

\*\*

Выполняет операцию экспонирования. Левый операнд поднят до степени правильного операнда

12 \*\* 3 = 1728

//

Выполняет операцию разделения пола. Возвращает интегральную часть частного, полученную после погружения левого операнда в правый операнд

18 // 5 = 3

Примечание. Чтобы получить результат в плавающем типе, один из операндов должен также иметь тип float.

#### Реляционные операторы

Для сравнения двух операндов используется реляционный оператор для определения отношения между ними. Он возвращает логическое значение, основанное на условии.

оператор

Описание

использование

\>

Возвращает True, если левый операнд больше, чем правый операнд Возвращает False в противном случае

12> 3 возвращает True

<

Возвращает True, если правый операнд больше, чем левый операнд Возвращает False в противном случае

12 <3 возвращает False

\==

Возвращает True, если оба операнда равны Возвращает False в противном случае

12 == 3 возвращает False

\> =

Возвращает True, если левый операнд больше или равен правильному операнду Возвращает False в противном случае

12> = 3 возвращает True

<=

Возвращает True, если правый операнд больше или равен левому операнду Возвращает False в противном случае

12 <= 3 возвращает False

знак равно

Возвращает True, если оба операнда не равны Возвращает False в противном случае

12! = 3 возвращает True

#### Побитовые операторы

Побитовый оператор выполняет операции по операндам по битам

Рассмотрим a = 2 (в двоичной нотации, 10) и b = 3 (в двоичной нотации, 11) для нижеследующих применений

оператор

Описание

использование

&

Выполняет побитовое И операцию над операндами

a & b = 2 Двоичный: 10 & 11 = 10

|

Выполняет побитовое ИЛИ операцию над операндами

a | b = 3 Двоичный: 10 | 11 = 11

^

Выполняет побитовое XOR-операцию над операндами

a ^ b = 1 Двоичный: 10 ^ 11 = 01

~

Выполняет побитовое НЕ операции над операндом Перемещает каждый бит в операнд

~ a = -3 Двоичный: ~ (00000010) = (11111101)

\>>

Выполняет побитовое смещение вправо. Сдвигает биты левого операнда, прямо на количество бит, указанное в качестве правильного операнда

a >> b = 0 Двоичный: 00000010 >> 00000011 = 0

<<

Выполняет побитовый сдвиг влево. Сдвигает биты левого операнда, оставшиеся от количества бит, заданных в качестве правильного операнда

a << b = 16 Двоичный: 00000010 << 00000011 = 00001000

#### Операторы присваивания

Оператор присваивания используется для назначения значений переменной. Обычно это объединяется с другими операторами (такими как арифметические, побитовые), где операция выполняется над операндами, а результат присваивается левому операнду.

Рассмотрим следующие примеры, **a = 18** . Здесь `=` - оператор присваивания, и результат сохраняется в переменной a. **a + = 10** . Здесь `+=` - оператор присваивания, и результат сохраняется в переменной a. Это то же самое, что и a = a + 10.

оператор

использование

знак равно

a = 5. Значение 5 присваивается переменной a

\+ =

a + = 5 эквивалентно a = a + 5

знак равно

а = 5 эквивалентно а = а - 5

знак равно

а \* = 3 эквивалентно а = а \* 3

знак равно

a / = 3 эквивалентно a = a / 3

знак равно

a% = 3 эквивалентно a = a% 3

знак равно

a \*\* = 3 эквивалентно a = a \*\* 3

знак равно

a // = 3 эквивалентно a = a // 3

знак равно

a = 3 эквивалентно a = a & 3

| =

a | = 3 эквивалентно a = a | 3

^ =

а ^ = 3 эквивалентно а = а ^ 3

\>> =

a >> = 3 эквивалентно a = a >> 3

<< =

a << = 3 эквивалентно a = a << 3

#### Логические операторы

Логический оператор используется для принятия решения на основе нескольких условий. Логические операторы, используемые в Python, `and` , `or` и `not`

оператор

Описание

использование

а также

Возвращает True, если оба операнда True Возвращает False в противном случае

a и b

или

Возвращает True, если любой из операндов True Возвращает False в противном случае

a или b

не

Возвращает True, если операнд False Возвращает False в противном случае

не

#### Операторы членства

Оператор членства используется для идентификации членства в любой последовательности (списки, строки, кортежи). `in` а `not in` операторы членства

`in` возвращает True, если указанное значение найдено в последовательности. Возвращает False в противном случае. `not in` возвращает True, если указанное значение не найдено в последовательности. Возвращает False в противном случае.

###### Пример использования

```py
a = [1,2,3,4,5] 
 
 #Is 3 in the list a? 
 print 3 in a # prints True 
 
 #Is 12 not in list a? 
 print 12 not in a # prints True 
 
 str = "Hello World" 
 
 #Does the string str contain World? 
 print "World" in str # prints True 
 
 #Does the string str contain world? (note: case sensitive) 
 print "world" in str # prints False 
 
 print "code" not in str # prints True 
```

#### Операторы идентификации

Оператор идентификации используется для проверки того, имеют ли две переменные одинаковое расположение памяти. `is` и `is not` есть операторы тождества

`is` возвращает Истина , если операнды относятся к одному объекту. Возвращает False в противном случае. `is not` возвращает True, если операнды не относятся к одному и тому же объекту. Возвращает False в противном случае.

Обратите внимание, что два значения, когда они равны, не обязательно должны совпадать.

###### Пример использования

```py
a = 3 
 b = 3 
 c = 4 
 print a is b # prints True 
 print a is not b # prints False 
 print a is not c # prints True 
 
 x = 1 
 y = x 
 z = y 
 print z is 1 # prints True 
 print z is x # prints True 
 
 str1 = "FreeCodeCamp" 
 str2 = "FreeCodeCamp" 
 
 print str1 is str2 # prints True 
 print "Code" is str2 # prints False 
 
 a = [10,20,30] 
 b = [10,20,30] 
 
 print a is b # prints False (since lists are mutable in Python) 

```