---
title: Python Calling Functions
localeTitle: Функции вызова Python
---
Оператор определения функции не выполняет функцию. Выполнение (вызов) функции выполняется с использованием имени функции, за которым следует скобка, в которой содержатся необходимые аргументы (если есть).
```
>>> def say_hello(): 
 ...     print('Hello') 
 ... 
 >>> say_hello() 
 Hello 
```

Выполнение функции представляет новую таблицу символов, используемую для локальных переменных функции. Точнее, все присваивания переменных в функции сохраняют значение в таблице локальных символов; в то время как ссылки на переменные сначала рассматриваются в таблице локальных символов, затем в таблицах локальных символов охватывающих функций, затем в глобальной таблице символов и, наконец, в таблице встроенных имен. Таким образом, глобальные переменные не могут быть напрямую назначены значения внутри функции (если не указано в глобальном заявлении), хотя на них можно ссылаться.
```
>>> a = 1 
 >>> b = 10 
 >>> def fn(): 
 ...     print(a)    # local a is not assigned, no enclosing function, global a referenced. 
 ...     b = 20      # local b is assigned in the local symbol table for the function. 
 ...     print(b)    # local b is referenced. 
 ... 
 >>> fn() 
 1 
 20 
 >>> b               # global b is not changed by the function call. 
 10 
```

Фактические параметры (аргументы) для вызова функции вводятся в локальную таблицу символов вызываемой функции при ее вызове; таким образом, аргументы передаются с использованием вызова по значению (где значение всегда является ссылкой на объект, а не значением объекта). Когда функция вызывает другую функцию, для этого вызова создается новая таблица локальных символов.
```
>>> def greet(s): 
 ...     s = "Hello " + s    # s in local symbol table is reassigned. 
 ...     print(s) 
 ... 
 >>> person = "Bob" 
 >>> greet(person) 
 Hello Bob 
 >>> person                  # person used to call remains bound to original object, 'Bob'. 
 'Bob' 
```

Аргументы, используемые для вызова функции, не могут быть переназначены функцией, но аргументы, которые ссылаются на изменяемые объекты, могут изменить их значения:
```
>>> def fn(arg): 
 ...     arg.append(1) 
 ... 
 >>> a = [1, 2, 3] 
 >>> fn(a) 
 >>> a 
 [1, 2, 3, 1] 

```