---
title: Class
localeTitle: Класс
---
## Класс

Классы обеспечивают возможность объединения данных и функциональных возможностей вместе. Создание нового класса создает новый тип объекта, позволяя создавать новые экземпляры этого типа. Каждый экземпляр класса может иметь прикрепленные к нему атрибуты для поддержания его состояния. У экземпляров класса также могут быть методы (определенные его классом) для изменения его состояния.

По сравнению с другими языками программирования, механизм класса Python добавляет классы с минимумом новый синтаксис и семантика. Это смесь классовых механизмов, найденных в C++. Классы Python предоставляют все стандартные функции объектно-ориентированного программирования: механизм наследования класса допускает множество базовых классов, производный класс может переопределять любые методы своего базового класса или классов, и метод может вызвать метод базового класса с тем же именем. Объекты могут содержать произвольные суммы и виды данных. Как и для модулей, классы участвуют в динамическом характере Python: они создаются во время выполнения и могут быть изменены после создания.

#### Синтаксис определения класса:

Простейшая форма определения класса выглядит следующим образом:

```python
class ClassName: 
    <statement-1> 
        ... 
        ... 
        ... 
    <statement-N> 
 ``` 
 При инстанциации класса используется специальный метод __init__ (читается как "дандер инит"). Если при инстанциации клиенту нужно предоставить какие-либо аргументы, это можно обозначить с помощью конструктора на базе метода __init__:
 

 #### Объекты классов: 
 
Объекты класса поддерживают два вида операций: ссылки на атрибуты и экземпляр.
 
В ссылках атрибутов используется стандартный синтаксис, используемый для всех ссылок на атрибуты в Python: `obj.name`.
Допустимые имена атрибутов - это все имена, которые были в пространстве имен класса при создании объекта класса.
Итак, если определение класса выглядит так:

```python
class MyClass:
    """ A simple example class """
    i = 12345


    def f(self):
        return 'hello world'
```

Тогда `MyClass.i` и `MyClass.f` являются допустимыми ссылками на атрибуты, возвращая целое число и объект функции соответственно.
Атрибуты класса также могут быть присвоены, поэтому вы можете изменить значение `MyClass.i` путем присваивания. `__doc__` также является допустимым атрибутом, возвращая docstring, принадлежащую классу: `Простой пример класса" `.
 
 Для создания экземпляра класса используется нотация функций. Просто представьте, что объект класса является функцией без параметров, которая возвращает новый экземпляр класса. Например (при условии, что указанный класс):

```python
x = MyClass()
```

Создает новый экземпляр класса и назначает этот объект локальной переменной x.
 
Операция создания экземпляра («вызов» объекта класса) создает пустой объект.
Многие классы создают объекты с экземплярами, настроенными для определенного начального состояния.
Для этого в классе можно определить специальный метод с именем __init__(), например:
```python
def __init__(self):
    self.data = []
```

Если класс определяет метод `__init __ ()`, то экземпляр класса автоматически вызывает `__init __ ()` для вновь созданного экземпляра класса.
Таким образом, в этом примере новый, инициализированный экземпляр может быть получен:

```python
x = MyClass()
```

Конечно, метод `__init __ ()` может иметь аргументы для большей гибкости.
В этом случае аргументы, заданные оператору экземпляра класса, передаются в `__init __ ()`. Например,

```python
class Complex:
    def __init__(self, realpart, imagpart):
        self.r = realpart
        self.i = imagpart
              ...

x = Complex(3.0, -4.5)
>>> x.r, x.i
(3.0, -4.5)
```

