---
title: Python Comparisons
localeTitle: Сравнение Python
---
[Документы Python - Сравнение](https://docs.python.org/3/library/stdtypes.html#comparisons)

В Python имеется восемь операций сравнения. Все они имеют одинаковый приоритет (что выше, чем у булевых операций). Сравнения могут быть скованы произвольно; например, `x < y <= z` эквивалентно `x < y and y <= z` , за исключением того, что `y` оценивается только один раз (но в обоих случаях `z` вообще не оценивается, когда `x < y` оказывается ложным).

В этой таблице приведены операции сравнения:

Операция | Имея в виду  
\--------- | -----------------------  
`<` | строго меньше  
`<=` | меньше или равно `>` | строго больше, чем `>=` | больше или равно `==` | равно `!=` | не равный `is` | идентификатор объекта  
`is not` | отрицательный идентификатор объекта

Объекты разных типов, кроме разных числовых типов, никогда не сравниваются с равными. Кроме того, некоторые типы (например, объекты функций) поддерживают только вырожденное понятие сравнения, где любые два объекта такого типа неравны. Операторы `<` , `<=` , `>` и `>=` будут вызывать исключение `TypeError` при сравнении сложного числа с другим встроенным числовым типом, когда объекты имеют разные типы, которые нельзя сравнивать, или в других случаях, когда нет определенных упорядоченность.

`__eq__()` экземпляры класса обычно сравниваются как не равные, если класс не определяет метод `__eq__()` .

Экземпляры класса не могут быть упорядочены относительно других экземпляров одного и того же класса или других типов объектов, если только класс не определяет достаточно методов `__lt__()` , `__le__()` , `__gt__()` и `__ge__()` (в общем случае , `__lt__()` и `__eq__()` достаточны, если вы хотите использовать обычные значения операторов сравнения).

Поведение `is` и `is not` операторы не могут быть настроены; также они могут применяться к любым двум объектам и никогда не создавать исключение.

Мы также можем связать операторы `<` и `>` . Например, `3 < 4 < 5` вернет `True` , но `3 < 4 > 5` не будет. Мы также можем связать оператор равенства. Например, `3 == 3 < 5` вернет `True` но `3 == 5 < 5` не будет.

### Сравнение равенств - "is" vs "=="

В Python есть два оператора сравнения, которые позволяют нам проверить, равны ли два объекта. Оператор `is` оператор `==` . Однако есть ключевое различие между ними!

Ключевое различие между «is» и «==» можно суммировать как:

*   `is` используется для сравнения **идентичности**
*   `==` используется для сравнения **равенства**

## пример

Сначала создайте список в Python.

```python
myListA = [1,2,3] 
```

Затем создайте копию этого списка.

```python
myListB = myListA 
```

Если мы используем оператор '==' или оператор 'is', оба будут иметь выход **True** .

```python
>>> myListA == myListB # both lists contains similar elements 
 True 
 >>> myListB is myListA # myListB contains the same elements 
 True 
```

Это связано с тем, что myListA и myListB указывают на ту же переменную списка, которую я определил в начале моей программы Python. Оба списка точно такие же, как в личном, так и в контенте.

Однако, что, если я сейчас создам новый список?

```python
myListC = [1,2,3] 
```

Выполнение оператора `==` все еще показывает, что оба списка одинаковы с точки зрения контента.

```python
>>> myListA == myListC 
 True 
```

Однако выполнение оператора `is` теперь приведет к выходу `False` . Это связано с тем, что myListA и myListC представляют собой две разные переменные, несмотря на то, что они содержат одни и те же данные. Хотя они выглядят одинаково, они **разные** .

```python
>>> myListA is myListC 
 False # both lists have different reference 
```

Подводить итоги:

*   An `is` выражение выводит `True` если обе переменные указывают на одну и ту же ссылку
*   Выражение `==` выводит значение `True` если обе переменные содержат одни и те же данные