---
title: Python Complex Numbers
localeTitle: Комплексные числа Python
---
Сложные числа имеют вещественную и мнимую часть, каждая из которых представлена ​​числом с плавающей запятой.

Мнимая часть комплексного числа может быть создана с использованием воображаемого литерала, это приводит к комплексному числу с вещественной частью `0.0` :

```python
>>> a = 3.5j 
 >>> type(a) 
 <class 'complex'> 
 >>> print(a) 
 3.5j 
 >>> a.real 
 0.0 
 >>> a.imag 
 3.5 
```

Нет литерала для создания сложного числа с ненулевой вещественной и мнимой частями. Чтобы создать ненулевое комплексное число действительной части, добавьте воображаемый литерал к числу с плавающей запятой:

```python
>>> a = 1.1 + 3.5j 
 >>> type(a) 
 <class 'complex'> 
 >>> print(a) 
 (1.1+3.5j) 
 >>> a.real 
 1.1 
 >>> a.imag 
 3.5 
```

Или используйте [сложный конструктор](https://docs.python.org/3/library/functions.html#complex) .

```python
class complex([real[, imag]]) 
```

Аргументы, используемые для вызова сложного конструктора, могут иметь числовой (в том числе `complex` ) тип для любого параметра:

```python
>>> complex(1, 1) 
 (1+1j) 
 >>> complex(1j, 1j) 
 (-1+1j) 
 >>> complex(1.1, 3.5) 
 (1.1+3.5j) 
 >>> complex(1.1) 
 (1.1+0j) 
 >>> complex(0, 3.5) 
 3.5j 
```

В качестве аргумента также может использоваться `string` . Второй аргумент не разрешен, если строка используется как аргумент

```python
>>> complex("1.1+3.5j") 
 (1.1+3.5j) 

```