---
title: Converting Integer to String in Python
localeTitle: Преобразование целочисленного в String в Python
---
## Преобразование целочисленного в String в Python

В отличие от многих других языков, Python не подразумевает, что цепочки целых чисел (или плавающие) не привязаны к строкам при конкатенации строками. К счастью, у Python есть удобная встроенная функция `str()` которая преобразует аргумент, переданный в строковый формат.

#### Неправильный путь

Программисты, поступающие с других языков, могут попытаться выполнить следующую конкатенацию строк, которая вызывает ошибку:

```py
age = 18 
 
 string = "Hello, I am " + age + " years old" 
```

[Выполнить код на repl.it](https://repl.it/JyYH/0)

Ошибка, которая появляется
```
Traceback (most recent call last): 
  File "python", line 3, in <module> 
 TypeError: must be str, not int 
```

`TypeError: must be str, not int` указывает, что целое число сначала должно быть преобразовано в строку, которая будет конкатенирована.

#### Правильный путь

Пример простой конкатенации:

```py
age = 18 
 
 print("Hello, I am " + str(age) + " years old") 
 
 # Output 
 # Hello, I am 18 years old 
```

[Выполнить код на repl.it](https://repl.it/Jz8Q/0)

Печать `1 2 3 4 5 6 7 8 9 10` с использованием одной строки

```py
result = "" 
 
 for i in range(1, 11): 
    result += str(i) + " " 
 
 print(result) 
 
 # Output 
 # 1 2 3 4 5 6 7 8 9 10 
```

[Выполнить код на repl.it](https://repl.it/KBLB/0)

#### Объяснение строки за строкой приведенного выше кода

1.  Прежде всего переменный «результат» присваивается пустой строке.
2.  Для цикла используется для перебора списка чисел.
3.  Этот список чисел генерируется с использованием функции диапазона.
4.  поэтому диапазон (1,11) будет генерировать список чисел от 1 до 10.
5.  На каждой итерации цикла эта переменная «i» будет принимать значения от 1 до 10.
6.  На первой итерации, когда переменная i = 1, тогда переменная \[result = result + str (i) + "(пробел)"\], str (i) преобразует значение «i», которое является целым значением в строковое значение.
7.  Так как i = 1, то на первой итерации окончательно результат = 1.
8.  И тот же процесс продолжается до i = 10 и, наконец, после последнего результата итерации = 1 2 3 4 5 6 7 8 9 10.
9.  Поэтому, когда мы окончательно печатаем результат после цикла for, вывод на консоли «1 2 3 4 5 6 7 8 9 10».

#### Дополнительная информация:

[Официальная документация на Python для `str()`](https://docs.python.org/3/library/stdtypes.html#str)