---
title: The Python Dict
localeTitle: Диктатор Питона
---
Словарь (aka «dict») в python - это встроенный тип данных, который можно использовать для хранения пар **`key-value`** . Это позволяет вам обращаться с **`dict`** как с _базой данных_ для хранения и организации данных.

Особенность словарей в том, как они реализованы. Хэш-табличная структура упрощает проверку существование - это означает, что мы можем легко определить, присутствует ли в словаре конкретный ключ без необходимости изучения каждый элемент. Интерпретатор Python может просто перейти к ключу местоположения и проверить, есть ли ключ.

Словари могут использовать практически любые произвольные типы данных, такие как строки, целые числа и т. Д. Для ключей. Однако значения, которые не являются хешируемыми, то есть значения, содержащие списки, словари или другие изменяемые типы (которые сравниваются по значению, а не по идентификатору объекта), могут не использоваться в качестве ключей. Числовые типы, используемые для ключей, подчиняются нормальным правилам для числового сравнения: если два числа сравниваются равными (например, `1` и `1.0` ), то они могут использоваться взаимозаменяемо для индексации одной и той же словарной записи. (Обратите внимание, однако, что, поскольку компьютеры хранят числа с плавающей запятой в качестве приближений, как правило, неразумно использовать их в качестве словарных ключей.)

Одним из важнейших требований словаря является то, что ключи **должны** быть уникальными.  
Чтобы создать пустой словарь, просто используйте пару фигурных скобок:

```python
    >>> teams = {} 
    >>> type(teams) 
    >>> <class 'dict'> 
```

  
Чтобы создать непустой словарь с некоторыми начальными значениями, поместите разделенный запятыми список пар ключ-значение:

```python
    >>> teams = {'barcelona': 1875, 'chelsea': 1910} 
    >>> teams 
    {'barcelona': 1875, 'chelsea': 1910} 
```

Легко добавить пары ключ-значение в существующий словарь:

```python
    >>> teams['santos'] = 1787 
    >>> teams 
    {'chelsea': 1910, 'barcelona': 1875, 'santos': 1787} # Notice the order - Dictionaries are unordered ! 
    >>> # extracting value - Just provide the key 
    ... 
    >>> teams['barcelona'] 
    1875 
```

  
**`del`** используется для удаления пары ключ-значение из dict. В сценариях, где ключ, который уже используется, снова используется для хранения значений, старое значение, связанное с этим ключом, полностью теряется. Кроме того, имейте в виду, что это ошибка для извлечения значения с использованием несуществующего ключа.

```python
    >>> del teams['santos'] 
    >>> teams 
    {'chelsea': 1910, 'barcelona': 1875} 
    >>> teams['chelsea'] = 2017 # overwriting 
    >>> teams 
    {'chelsea': 2017, 'barcelona': 1875} 
```

  
**`in`** ключевом слове может быть использована для проверки , существует ли ключ в Словаре или нет:

```python
    >>> 'sanots' in teams 
    False 
    >>> 'barcelona' in teams 
    True 
    >>> 'chelsea' not in teams 
    False 
```

  
**`keys`** - это встроенный _метод,_ который можно использовать для получения ключей данного словаря. Чтобы извлечь ключи, присутствующие в списках dict:

```python
    >>> club_names = list(teams.keys()) 
    >>> club_names 
    ['chelsea', 'barcelona'] 
```

  
Еще один способ создания словаря - использовать метод **`dict()`** :

```python
    >>> players = dict( [('messi','argentina'), ('ronaldo','portugal'), ('kaka','brazil')] ) # sequence of key-value pair is passed 
    >>> players 
    {'ronaldo': 'portugal', 'kaka': 'brazil', 'messi': 'argentina'} 
    >>> 
    >>> # If keys are simple strings, it's quite easier to specify pairs using keyword arguments 
    ... 
    >>> dict( totti = 38, zidane = 43 ) 
    {'zidane': 43, 'totti': 38} 
```

Понимание Dict также может быть использовано для создания словарей из произвольных выражений ключа и значения:

```python
    >>> {x: x**2 for x in (2, 4, 6)} 
    {2: 4, 4: 16, 6: 36} 
```

**Цикл в словаре**  
Чтобы просто перебрать ключи в словаре, а не клавиши и значения:

```python
    >>> d = {'x': 1, 'y': 2, 'z': 3} 
    >>> for key in d: 
    ...     print(key) # do something 
    ... 
    x 
    y 
    z 
```

Чтобы перебрать оба ключа и значения, вы можете использовать следующее:  
Для Python 2.x:

```python
    >>> for key, item in d.iteritems(): 
    ...     print items 
    ... 
    1 
    2 
    3 
```

Используйте **`items()`** для Python 3.x:

```python
    >>> for key, item in d.items(): 
    ...     print(key, items) 
    ... 
    x 1 
    y 2 
    z 3 

```