---
title: Python Integers
localeTitle: Цепочки Python
---
Теоретическая область для целых чисел в python является отрицательной бесконечностью до бесконечности. На практике целочисленные значения ограничены объемом доступной памяти.

В Python 2 существует различие между **`int`** , числами, которые соответствуют 32 или 64-битным _C длинным_ и **`long`** номерам, ограниченным доступной памятью. Python 3 объединил два типа в **`int`** , больше информации в [PEP 237](https://www.python.org/dev/peps/pep-0237/) .

**создание `int` с использованием целочисленных литералов**

[Целочисленные литеры](https://docs.python.org/3/reference/lexical_analysis.html#integer-literals)

_Целочисленные объекты_ могут быть созданы с использованием целочисленных литералов. Безсердечные числа без десятичных знаков являются целыми литералами:
```
>>> 1234567890           # Unadorned numbers are integer literals 
 1234567890 
 >>> type(1234567890) 
 <class 'int'> 
```

Числовые литералы не содержат знак, однако создания отрицательных _целых объектов_ можно предваряя с одноместный `-` (минус) оператором без пробела перед буквальным:
```
>>> -1234567890 
 -1234567890 
 >>> type(-1234567890) 
 <class 'int'> 
```

Аналогично, положительные целые объекты могут быть созданы путем префикса унарного `+` (плюс) оператора без пробела перед цифрами. Обычно `+` омрачивается:
```
>>> +1234 
 1234 
```

Бинарные (base 2, prefix: `0b` или `0B` ), восьмеричные (base 8, prefix: `0o` или `0O` ) и шестнадцатеричные (базовые 16, префикс: `0x` или `0X` ) целые числа также могут быть созданы с использованием целочисленных литералов:
```
>>> 0b1, 0b10, 0b11 
 (1, 2, 3) 
 >>> 0o1, 0o10, 0o11 
 (1, 8, 9) 
 >>> 0x1, 0x10, 0x11 
 (1, 16, 17) 
```

Обратите внимание, что ведущие 0 для ненулевых целых литералов **не допускаются** :
```
>>> 0     # Zero by itself is okay. 
 0 
 >>> 01    # Leading zero(s) cause SyntaxError. 
  File "<stdin>", line 1 
    01 
     ^ 
 SyntaxError: invalid token 
```

`int` [конструктор](https://docs.python.org/3/library/functions.html#int) еще один способ создать _целые объекты._
```
class int(x=0) 
 class int(x, base=10) 
```

При необходимости предпочтительнее создавать _целые объекты_ с целыми литералами:
```
>>> a = 1         # Prefer integer literal when possible. 
 >>> type(a) 
 <class 'int'> 
 >>> b = int(1)    # Works but unnecessary. 
 >>> type(b) 
 <class 'int'> 
```

Однако конструктор позволяет создавать _целые объекты_ из других типов номеров:
```
>>> a = 1.123 
 >>> type(a) 
 <class 'float'> 
 >>> print(a) 
 1.123 
 >>> b = int(1.123) 
 >>> type(b) 
 <class 'int'> 
 >>> print(b) 
 1 
```

Использование конструктора `int` для чисел с плавающей запятой усекает число до нуля:
```
>>> int(-1.23) 
 -1 
 >>> int(1.23) 
 1 
```

Встроенные `boolean` константы являются экземплярами класса `bool` и являются подклассами класса `int` , что делает их своего рода числовым типом:
```
>>> type(True) 
 <class 'bool'> 
 >>> issubclass(bool, int) 
 True 
```

Если это не имеет смысла для вас, не беспокойтесь. Теперь просто помните, что вызов конструктора int с `boolean` объектами будет возвращать _целые объекты_ :
```
>>> int(True) 
 1 
 >>> int(False) 
 0 
```

Конструктор `int` также будет делать _целые объекты_ из строк:
```
>>> a = "10" 
 >>> type(a) 
 <class 'str'> 
 >>> b = int("10") 
 >>> type(b) 
 <class 'int'> 
```

_Строки_ для конструктора `int` должны представлять целочисленный литерал:

Второй параметр конструктора `int` - это указать базу (по умолчанию: 10). Допустимые значения: 0 и 2-36.

Если явная база предоставляется, первым аргументом должна быть строка.
```
>>> int("111", 2) 
 7 
 >>> int(111, 2) 
 Traceback (most recent call last): 
  File "<stdin>", line 1, in <module> 
 TypeError: int() can't convert non-string with explicit base 
```

Строка, используемая для конструктора `int` с явной базой, должна быть допустимым целым литералом для этой базы:
```
>>> int('11', 2) 
 3 
 >>> int('12', 2) 
 Traceback (most recent call last): 
  File "<stdin>", line 1, in <module> 
 ValueError: invalid literal for int() with base 2: '12' 
```

Можно использовать как префиксные, так и не префиксные строки целых литералов, однако, если они используются, префикс должен соответствовать предоставленной базе.
```
>>> int('1101', 2) 
 13 
 >>> int('0b1101', 2) 
 13 
 >>> int('0x1101', 2) 
 Traceback (most recent call last): 
  File "<stdin>", line 1, in <module> 
 ValueError: invalid literal for int() with base 2: '0x1101' 
```

Если используется префиксная строка и база 0, созданный целочисленный объект будет использовать базу, указанную префиксом. Если префикс не используется, то основание предполагается 10
```
>>> int('100', 0) 
 100 
 >>> int('0b100', 0) 
 4 
 >>> int('0o100', 0) 
 64 

```