---
title: Difference between Python 'is' and '==' operators
localeTitle: Разница между операторами Python 'is' и '=='
---
`is` является проверка идентичности объекта - то есть, проверка , если два или более переменных имеют в виду тот же объект. Вы не можете перегрузить `is` .

`==` оценивает значение true, если объект, на который ссылаются переменные, равен. Вы можете перегружать `==` помощью оператора `__eq__` .

## Возвращаемое значение

Возвращаемое значение для обоих будет равно `True` или `False` .

## Образец кода
```
a = 2.3 
 a is 2.3  # => False 
 a == 2.3  # => True 
 
 a = [234,123,321] 
 b = [234,123,321] 
 a == b  # => True 
 a is b  # => False 
 a = b 
 a == b  # => True 
 a is b  # => True, because if we change a, b changes too 

```