---
title: For Loop Statements
localeTitle: Записи цикла
---
## Записи цикла

Python использует цикл for для перебора списка элементов. В отличие от C или Java, которые используют цикл for для изменения значения в шагах и доступа к чему-то, например массиву, используя это значение.

Для циклов итерации по структурам данных на основе сбора данных, таким как списки, кортежи и словари.

Основной синтаксис:

```python
for value in list_of_values: 
  # use value inside this block 
```

В общем, вы можете использовать что-либо как значение итератора, где могут быть назначены записи итерации. Например, вы можете распаковать кортежи из списка кортежей:

```python
list_of_tuples = [(1,2), (3,4)] 
 
 for a, b in list_of_tuples: 
  print("a:", a, "b:", b) 
```

С другой стороны, вы можете перебрать все, что итерабельно. Вы можете вызвать функцию или использовать литерал списка.

```python
for person in load_persons(): 
  print("The name is:", person.name) 
```

```python
for character in ["P", "y", "t", "h", "o", "n"]: 
  print("Give me a '{}'!".format(character)) 
```

Некоторые способы использования циклов For:

**Итерация по функции range ()**

```python
for i in range(10): 
    print(i) 
```

Вместо того, чтобы быть функцией, диапазон фактически является неизменным типом последовательности. Результат будет содержать результаты от нижней границы, т. Е. 0 до верхней границы, т. Е. 10, но исключая 10.By по умолчанию нижняя граница или начальный индекс устанавливается на ноль. Вывод:
```
> 
 0 
 1 
 2 
 3 
 4 
 5 
 6 
 7 
 8 
 9 
 > 
```

Кроме того, можно указать нижнюю границу последовательности и даже шаг последовательности, добавив второй и третий параметры.

```python
for i in range(4,10,2): #From 4 to 9 using a step of two 
    print(i) 
```

Вывод:
```
> 
 4 
 6 
 8 
 > 
```

**Функция xrange ()**

По большей части, xrange и range являются точными с точки зрения функциональности. Они оба предоставляют способ генерации списка целых чисел для вас, но, как вам угодно. Единственное различие заключается в том, что диапазон возвращает объект списка Python, а xrange возвращает объект xrange. Это означает, что xrange фактически не создает статический список во время выполнения, например, диапазон. Он создает ценности по мере необходимости с помощью специального метода, называемого yielding. Этот метод используется с типом объекта, который известен как генераторы.

Еще одна вещь, которую нужно добавить. В Python 3.x функция xrange больше не существует. Функция диапазона теперь делает то, что делает xrange в Python 2.x

**Итерировать значения в списке или кортеже**

```python
A = ["hello", 1, 65, "thank you", [2, 3]] 
 for value in A: 
    print(value) 
```

Вывод:
```
> 
 hello 
 1 
 65 
 thank you 
 [2, 3] 
 > 
```

**Итерации по клавишам в словаре (aka hashmap)**

```python
fruits_to_colors = {"apple": "#ff0000", 
                    "lemon": "#ffff00", 
                    "orange": "#ffa500"} 
 
 for key in fruits_to_colors: 
    print(key, fruits_to_colors[key]) 
```

Вывод:
```
> 
 apple #ff0000 
 lemon #ffff00 
 orange #ffa500 
 > 
```

**Итерацию над двумя списками одинакового размера в одном цикле с помощью функции zip ()**

A = \["a", "b", "c"\] B = \["a", "d", "e"\]
```python
for a, b in zip(A, B):
  print(a, b, a == b)
```
Вывод: 
```
a a True
b d False
c e False
```

Можно **for** использовать с функцией **enumerate()** для получения индекса итерируемого объекта:
```python
A = ['Первый объект', 'Второй объект', 'Третий объект']

for index, item in enumerate(A):
  print('Индекс:', index, '--->', item)
```
Вывод:
```
Индекс: 0 ---> Первый объект
Индекс: 1 ---> Второй объект
Индекс: 2 ---> Третий объект
```

На самом деле, функция **for** может быть использована с любым объектом который годен для итерации, включая итераторов и генераторов (iterator objects, generator objects). Дополнительная информация доступна по следующим ссылкам:

*   [Документация Python2 для цикла](https://docs.python.org/2.7/tutorial/controlflow.html#for-statements)
    
*   [Python3 для документации по циклам](https://docs.python.org/3/tutorial/controlflow.html#for-statements)
