---
title: Python from X Import Y
localeTitle: Python из X Импорт Y
---
Если вы прочитали `import statements` wiki `import statements` вы бы увидели, как я использую этот оператор в одном из примеров. Сегодня мы постараемся понять, что он делает

Итак, возьмем тот же пример:
```
>>> from math import ceil, sqrt 
 >>> # here it would be 
 >>> sqrt(36) 
 <<< 6 
```

![:rocket:](//forum.freecodecamp.com/images/emoji/emoji_one/rocket.png?v=2 ": Ракета:") [Код запуска](https://repl.it/CS5t/1)

Или мы могли бы использовать это:
```
>>> import math 
 >>> # here it would be 
 >>> math.sqrt(36) 
 <<< 6 
```

![:rocket:](//forum.freecodecamp.com/images/emoji/emoji_one/rocket.png?v=2 ": Ракета:") [Код запуска](https://repl.it/CS5u)

Тогда наш код будет выглядеть как `math.sqrt(x)` вместо `sqrt(x)` . Это происходит потому, что, когда мы используем `import x` , пространство имен `x` создается самим, чтобы избежать конфликтов имен. Вы должны получить доступ к каждому объекту модуля как `x.<name>` . Но когда мы используем `from x import y` мы соглашаемся добавить `y` в основное глобальное пространство имен. Поэтому при использовании этого мы должны убедиться, что у нас нет объекта с таким же именем в нашей программе.

> **Никогда не используйте `from x import y` если объект с именем `y` уже существует**

Например, в `os` модуле есть метод `open` . Но у нас даже есть встроенная функция `open` . Итак, здесь нам следует избегать использования `from os import open` .

Мы даже можем использовать `form x import *` , это будет импортировать все методы, классы этого модуля в глобальное пространство имен программы. Это плохая практика программирования. Пожалуйста, избегайте этого.

В общем, вам следует избегать `from x import y` просто из-за проблем, которые могут возникнуть в крупномасштабных программах. Например, вы никогда не знаете, может ли другой программист создать новую функцию, которая называется именем одной из существующих функций. Вы также не знаете, изменит ли Python библиотеку, из которой вы импортируете функции. Хотя эти проблемы не будут существовать так часто для сольных проектов, как было сказано ранее, это плохая практика программирования, и ее следует избегать.