---
title: Itertools
localeTitle: Itertools
---
Itertools - это модуль функций python, возвращающий генераторы, объекты, которые работают только при повторении. Некоторые примеры функций itertool включают, но не ограничиваются следующими: chain (), imap (), product () и compress ().

### chain()

Функция chain() принимает несколько итераторов в качестве аргументов и возвращает один итератор, который создает содержимое всех из них, как если бы они поступали из одной последовательности.

```py
import itertools 
 list(itertools.chain([1, 2], [3, 4])) 
 
 # Output 
 # [1, 2, 3, 4] 
```

### islice()

Функция islice() возвращает итератор, который возвращает выбранные элементы из входного итератора по индексу. Он принимает те же аргументы, что и оператор среза для списков: старт, стоп и шаг. Запуск и остановка являются необязательными.

```py
import itertools 
 list(itertools.islice(count(), 5)) 
 
 # Output 
 # [0,1, 2, 3, 4] 
```

### izip ()

izip() возвращает итератор, который объединяет элементы нескольких итераторов в кортежи. Он работает как встроенная функция zip (), за исключением того, что возвращает итератор вместо списка.

```py
import itertools 
 list(izip([1, 2, 3], ['a', 'b', 'c'])) 
 
 # Output 
 # [(1, 'a'),(2, 'b'),(3, 'c')] 
```

Комбинаторные итераторы:

Итерационные аргументы product () p, q, ... \[repeat = 1\] декартово произведение, эквивалентное вложенному циклу перестановки () p \[, r\] r-длины, все возможные упорядочения, не повторяющиеся элементы комбинаций () p, r r-length кортежей в отсортированном порядке, без повторных элементов комбинации _с_ заменами () p, r r-length кортежей в отсортированном порядке с повторяющимися элементами продукт ('ABCD', repeat = 2) AA AB AC AD BA BB BC BD CA CB CC CD DA DB DC DD перестановки ('ABCD', 2) AB AC AD BA BC BD CA CB CD DA DB DC

комбинации ('ABCD', 2) AB AC AD BC BD CD

комбинации _с_ заменой («ABCD», 2) AA AB AC AD BB BC BD CC CD DD

Источник: https://docs.python.org/3/library/itertools.html
